//
//  WMLauchManager.m
//  Gengmei
//
//  Created by Sean Lee on 1/15/15.
//  Copyright (c) 2015 Wanmeichuangyi. All rights reserved.
//

#import "GMLaunchManager.h"

#define kTabbarTitleColor @"kTabbarTitleColor"

static GMLaunchManager *sharedManager = nil;
static NSString *greetingAdKey = @"greetingAdKey";
static NSString *tabbarIconsKey = @"tabbarIconsKey";

@implementation GMLaunchManager

+ (instancetype)shareManager{
    static dispatch_once_t oncePredicate;
    dispatch_once(&oncePredicate,^{
        sharedManager = [[GMLaunchManager alloc]init];
    });
    return sharedManager;
                  
}

+ (void)startStatisticalAppLaunchCount{
    GMLaunchManager * manager = [GMLaunchManager shareManager];
    [manager startStatisticalAppLaunchCountForAllVersion];
    [manager startStatisticalAppLaunchCountForEveryVersion];
}


- (instancetype)init
{
    self = [super init];
    if (self) {
        _appConfigObject = [[WMAppConfigObject alloc]init];
    }
    return self;
}


- (NSInteger)lauchCountForAllVersion{
    return [[NSUserDefaults standardUserDefaults] integerForKey:@"launchCountForAllVersion"];
}

- (NSInteger)lauchCountForVersion:(NSString *)version{
    return [[NSUserDefaults standardUserDefaults] integerForKey:version];
}

#pragma mark - 大广告
- (void)saveGreeting {
    // 启动属于用户重要数据，如果存储在沙河cache目录下，当系统内存紧张时候，系统可能会删除数据，所以必须存储在Document目录下
    if (_appConfigObject.greeting) {
        [GMCache storeObjectAtDocumentPathWithkey:greetingAdKey object:_appConfigObject.greeting block:NULL];
    } else {
        [GMCache removeObjectAtDocumentPathWithkey:greetingAdKey block:NULL];
    }
}

+ (WMLaunchScreenObject *)greeting {
    return [GMCache fetchObjectAtDocumentPathWithkey:greetingAdKey];
}

// 是否显示大广告页。上一次saave当下一次启动，使用
+ (BOOL)greetingImageExist {
    WMLaunchScreenObject *greeting = [GMCache fetchObjectAtDocumentPathWithkey:greetingAdKey];
    BOOL imageExist = [[SDImageCache sharedImageCache] diskImageExistsWithKey:greeting.image];
    return imageExist;
}

// 根据app_config接口返回数据，以决定是否要下载大广告，或者删除缓存中的大广告
+ (void)downloadGreetingImage {
    WMLaunchScreenObject *greeting = [GMLaunchManager shareManager].appConfigObject.greeting;
    if (greeting && [greeting.image isNonEmpty]) {
        BOOL imageExist = [[SDImageCache sharedImageCache] diskImageExistsWithKey:greeting.image];
        if (!imageExist) {
            [[SDWebImageManager sharedManager] downloadImageWithURL:[NSURL URLWithString:greeting.image] options:0 progress:nil completed:^(UIImage *image, NSError *error, SDImageCacheType cacheType, BOOL finished, NSURL *imageURL) {
                if (image) {
                    [[SDImageCache sharedImageCache] storeImage:image forKey:greeting.image];
                }
            }];
        }
    }
}

#pragma mark - private method
/**
 *  @brief  对应用程序每个版本，以版本号为key进行统计启动次数
 */
- (void)startStatisticalAppLaunchCountForEveryVersion{
    
    NSString *currentVersion = APP_VERSION;
    NSInteger count = [[NSUserDefaults standardUserDefaults] integerForKey:currentVersion];
    [[NSUserDefaults standardUserDefaults] setInteger:++count forKey:currentVersion];
    [[NSUserDefaults standardUserDefaults] synchronize];
}

/**
 *  @brief  对应用程序不分版本，每个版本启动次数累计统计启动次数
 */
- (void)startStatisticalAppLaunchCountForAllVersion{
    
    NSString * key = @"launchCountForAllVersion";
    NSInteger count = [[NSUserDefaults standardUserDefaults] integerForKey:key];
    [[NSUserDefaults standardUserDefaults] setInteger:++count forKey:key];
    [[NSUserDefaults standardUserDefaults] synchronize];
}


+ (void)jumpToAppStore{
    NSURL *iTunesURL = [NSURL URLWithString:APP_STORE_LINK];
    if (SYSTEM_VERSION_GREATER_THAN_OR_EQUAL_TO(@"10.0")) {
        [[UIApplication sharedApplication] openURL:iTunesURL options:@{} completionHandler:NULL];
    } else {
        [[UIApplication sharedApplication] openURL:iTunesURL];
    }
}


@end
