//
//  WMLoginObject.h
//  Gengmei
//  登录成功会返回的对象
//  Created by Thierry on 2/11/15.
//  Copyright (c) 2015 Wanmeichuangyi. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "WMUser.h"
#import "GMSignInManager.h"
#import "ALSignInViewController.h"

NS_ASSUME_NONNULL_BEGIN
/**
 *  @brief  从持久化存储中获取登录信息
 *
 */
@interface GMLoginManager : NSObject


+ (instancetype)shareInstance;

/**
 *  @author wangyang, 15-11-16 15:11:35
 *
 *  @brief 用户信息。设置成只读属性,不允许给 user 重新赋值。由于在很多 controller 里都对 user 的属性做了监听，给 user 重新赋值会导致 crash，即使在调用 showHomeView 之前或者之后也不行。
 *  @since 5.5.0
 */
@property (nonatomic, readonly) WMUser *user;

/**
 *  @author wangyang, 15-11-18 10:11:29
 *
 *  @brief  如果是访客模式，一些功能是禁用的，会弹出登录窗口
 *  @since 5.5.0
 */
@property (nonatomic, assign, readonly) BOOL isVisitor;

// 保存用户信息
- (void)saveUserWithUserInfo:(NSDictionary *)dic;

/**
 * 保存user到沙盒cache目录下
 */
- (void)saveUser;
/**
 *  @brief 保存用户信息，并做额外的操作。shouldBroadcast: 是否发出一个登录成功的通知
 */
- (void)loginSuccessWithUserInfo:(NSDictionary *)dic shouldBroadcast:(BOOL)broadcast;
- (void)loginCancel;
/**
 *  @brief  询问是否要登出
 */
- (void)shouldLogout;

/**
 *  @author wangyang, 15-11-13 12:11:54
 *
 *  @brief  判断是否需要显示登录窗口，如果需要就显示
 *  @return YES 表示显示
 *  @since 5.5.0
 */
- (BOOL)showLoginViewIfNeeded;

- (void)doLogoutAndShowLoginView;
/**
 *  @author wangyang, 16-12-31 16:12:43
 *
 *  @brief 先logout，然后showHomeView
 *  @since 5.8.0
 */
- (void)doLogoutAndShowHomeView;

/**
 * 登出，不需要显示登录和首页
 */
- (void)doLogout;

/**
 app 打开后注册极光id
 */
- (void)appOpenJpushRegistration;

/**
 app 登录成功后注册极光id
 */
- (void)loginJpushRegistration;

@end
NS_ASSUME_NONNULL_END
