//
//  GMSignInManager.h
//  Gengmei
//
//  Created by Terminator on 2017/8/21.
//  Copyright © 2017年 更美互动信息科技有限公司. All rights reserved.
//

#import "GMThirdPartyLoginHelper.h"

typedef NS_ENUM(NSInteger, ALSignInType) {
    ALSignInTypeUNKNOWN     = 0,// 未知
    ALSignInTypePhone       = 1,// 手机号
    ALSignInTypeEmail       = 2,// 邮箱
    ALSignInTypeSinaBlog    = 3,// 新浪微博
    ALSignInTypeQQ          = 4,// QQ
    ALSignInTypeWeChat      = 5 // 微信
};// 登录注册类型

typedef NS_ENUM(NSInteger, ALVfcType) {
    ALVfcTypeLogin          = 1,// 登录
    ALVfcTypeRegister       = 2,// 注册
    ALVfcTypeRev_Pwd        = 3,// 找回密码
    ALVfcTypeBind           = 4 // 绑定操作
    
};// 验证码类型

#import <GMBase/GMBase-umbrella.h>
@interface GMSignInManager : NSObject
+ (instancetype)sharedManager;

@property (nonatomic, strong) NSString *referer;

/**
 *  @brief  第三方登陆
 */
+ (void)loginWithType:(GMSharePlatform)shareType finishBlock:(FinishBlock)finishBlock;

/**
 * @brief  获取验证码
 */
+ (void)sendVerifyCodeAccount_type:(ALSignInType)account_type
                           vfcType:(ALVfcType)vfcType
                             email:(NSString *)email
                             phone:(NSString *)phone
                       finishBlock:(FinishBlock)finishBlock;
/**
 *  @brief  用户注册
 */
+ (void)registerWithAccount_type:(ALSignInType)account_type
                         vfcType:(NSString *)vfcType
                           email:(NSString *)email
                           phone:(NSString *)phone
                             pwd:(NSString *)pwd
                     finishBlock:(FinishBlock)finishBlock;
/**
 *  @brief  用户登录
 */
+ (void)loginWithAccount_type:(ALSignInType)account_type
                        email:(NSString *)email
                        phone:(NSString *)phone
                          pwd:(NSString *)pwd
                  finishBlock:(FinishBlock)finishBlock;

/**
 *  @brief  用户注销
 */
+ (void)loginOut:(FinishBlock)finishBlock;


/**
 * @brief  绑定手机号
 */
+ (void)bindAccount:(ALSignInType)account_type
              email:(NSString *)email
              phone:(NSString *)phone
               code:(NSString *)code
             userId:(NSInteger)userId
        finishBlock:(FinishBlock)finishBlock;

/**
 * @brief  获取用户信息
 */
+ (void)getUserProfileUserId:(NSInteger)userId
                 finishBlock:(FinishBlock)finishBlock;

/**
 * @brief  设置用户信息
 */
+ (void)setUserProfileUserId:(NSInteger)userId
                  country_id:(NSString *)country_id
                   nick_name:(NSString *)nick_name
                 profile_pic:(NSString *)profile_pic
                         age:(NSString *)age
                 finishBlock:(FinishBlock)finishBlock;
@end
