//
//  WMConfigObject.h
//  Gengmei
//
//  Created by licong on 11/27/15.
//  Copyright © 2015 Wanmeichuangyi. All rights reserved.
//

#import <GMBase/GMObject.h>

@class WMCityObject;
typedef NS_ENUM(NSInteger , GMHomePopType){
    GMHomePopTypeNull = 0, // 无处理
    GMHomePopTypeForceUpdate = 1, //强制升级
    GMHomePopTypeUpdateVersion = 2,//更新提示
    GMHomePopTypeAD = 3,//小广告
    GMHomePopTypeUpdateCity = 4,//更换城市提示
    GMHomePopTypeGoodPraice = 5,//求好评
    GMHomePopTypeCashRedPacket = 6,//现金红包
    GMHomePopTypeInviteRedPacket = 7,//邀请好友红包
};

/**
 *  优先级最高的弹出窗内容
 */
@interface WMConfigPopObject : GMObject
@property (nonatomic , strong) NSString *url;
@property (nonatomic , strong) NSString *image;
/**
 *  用当前id记录某一个特定的弹窗是不是已经出现过，如果有，以后就不再弹
 */
@property (nonatomic , strong) NSString *id;
@end



@interface WMLaunchScreenObject : GMObject
@property (nonatomic ,strong) NSString *url;
@property (nonatomic ,strong) NSString *image;
@property (nonatomic ,assign) NSInteger id;
@end

@interface GMCurrentVersion : GMObject
@property (nonatomic, copy) NSString *version;
@property (nonatomic, copy) NSString *desc;
@end

/**
 服务器返回的tab上的icon
 */
@protocol GMTabIconConfigObject @end
@interface GMTabIconConfigObject : GMObject
@property (nonatomic, copy) NSString *iconNormal;
@property (nonatomic, copy) NSString *iconPressed;
@property (nonatomic, strong) UIImage *normalImage;
@property (nonatomic, strong) UIImage *pressedImage;
@property (nonatomic, copy) NSString *colourPressed;
@property (nonatomic, copy) NSString *colourNormal;
@end

@protocol WMConfigObject @end

@interface WMAppConfigObject : GMObject

/**
 *  @author licong, 15-11-27 16:11:43
 *
 *  是否展示第三方登陆入口
 *
 *  @since 5.5
 */

@property (nonatomic,assign) BOOL showThirdpartyLoginIcon;

/**
 *  @author licong, 15-11-27 16:11:43
 *
 *  是否展示精品应用
 *
 *  @since 5.5
 */

@property (nonatomic,assign) BOOL showSelectedApps;

/**
 *  @author zhaiguojun,
 *
 *  首页弹窗内容
 *
 *  @since 5.6
 */
@property (nonatomic , strong) WMConfigPopObject *popup;

/**
 意见反馈的url
 @author zhaiguojun 16-08-30 in 6.3.0
 */
@property (nonatomic, copy) NSDictionary *feedbackCsGroup;

/**
 *  @author licong,
 *
 *  开屏页
 *
 *  @since 5.6
 */
@property (nonatomic, strong) WMLaunchScreenObject *greeting;


/**
 *  @author 翟国钧, 16-02-19 14:02:25
 *
 *  @brief 针对所有首页弹窗的优先级的值
 *
 *  @since 5.9.1
 */
@property (nonatomic , assign) GMHomePopType type;

/**
 *  @author 翟国钧, 16-02-19 15:02:00
 *
 *  @brief 首页弹窗中的城市信息
 *
 *  @since 5.9.1
 */
@property (nonatomic , strong) WMCityObject *city;

@property (nonatomic, strong) GMCurrentVersion *currentVersion;

@property (nonatomic, strong) NSMutableArray<GMTabIconConfigObject> *tabs;

/**
  7.3.0添加搜索框文案
 */
@property (nonatomic, strong) NSString * searchPlaceholder;

/**
 7.6.20添加从首页、发现页进入搜索页后，是否命中灰度。
 */
@property (nonatomic, assign) BOOL isSearch;
/**
 7.6.45 搜索结果页面知识 tab 是否灰度
 */
@property (nonatomic, assign) BOOL hasSearchKnowledgeTab;
/**
 7.6.70 是否显示广告标签（目前只有首页精选列表)
 */
@property (nonatomic, assign) BOOL showAd;
/** 7.6.90 搜索V3界面(灰度) */
@property (nonatomic, assign) BOOL isContentSearch;

/**
 7725:机构主页改版：
 如果为True 访问   /phantom/organization/:id
 如果为False 访问  /hybrid/organization/:id
 */
@property (nonatomic, assign) BOOL isHitOrgHomeGray;

@end


