//
//  NSAttributedString+Frame.h
//  GMAlpha
//
//  Created by zhb on 2018/11/28.
//  Copyright © 2018 Gengmei. All rights reserved.
//

#import <Foundation/Foundation.h>

@interface NSAttributedString (Frame)

/**
 计算字符串的size

 @param maxWidth 最大宽度
 @return size
 */
- (CGSize)attributedStringSizeFromMaxWidth:(CGFloat)maxWidth;
/**
 获取字符串行数
 
 @param maxWidth 最大宽度
 @return 行数
 */
- (NSUInteger)getLineCountWithMaxWidth:(CGFloat)maxWidth;

/**
 获取字符串某一行的frame
 
 @param lineNum 行数（0~count-1）
 @param isLastLine 是否获取最后一行
 @param maxWidth 最大宽度
 @return 获取属性字符串某一行的frame
 */
- (CGRect)getLineNumRectFromLineNum:(NSUInteger)lineNum isLastLine:(BOOL)isLastLine maxWidth:(CGFloat)maxWidth;


/**
 获取属性字符串最后一行的frame
 
 @param maxWidth 最大宽度
 @return 获取属性字符串最后一行的frame
 */
- (CGRect)getLastLineRectFromMaxWidth:(CGFloat)maxWidth;

/**
 获取属性字符串某一行之前的所有字符串
 
 @param lineNum 行数（0~count-1）
 @param deleteStringLength 要删除的字符长度
 @param maxWidth 最大宽度
 @return 字符串
 */
- (NSMutableAttributedString *)getLineNumBeforeAttrStingFromLineNum:(NSUInteger)lineNum
                                                 deleteStringLength:(NSUInteger)deleteStringLength
                                                           maxWidth:(CGFloat)maxWidth;

@end
