//
//  GMSafeValue.h
//  Gengmei
//
//  Created by wangyang on 2017/1/17.
//  Copyright © 2017年 更美互动信息科技有限公司. All rights reserved.
//


#import <Foundation/Foundation.h>
#define SafeValue(someValue) [GMSafeValue safeValue:someValue]
#define SafeString(str) [GMSafeValue safeString:str]
#define SafeNumber(num) [GMSafeValue safeNumber:num]
#define NullableString(str) [GMSafeValue nullableString:str]
#define NullableNumber(num) [GMSafeValue nullableNumber:num]

NS_ASSUME_NONNULL_BEGIN
@interface GMSafeValue : NSObject
+ (nonnull id)safeValue:(id)object;

/*手动从字典中解析string或者number时使用下面4个方法*/

+ (nonnull NSString *)safeString:(id)str;
+ (nonnull NSNumber *)safeNumber:(id)num;
+ (nullable NSString *)nullableString:(id)str;
+ (nullable NSNumber *)nullableNumber:(id)num;
@end
NS_ASSUME_NONNULL_END
