//
//  GMSafeValue.m
//  Gengmei
//
//  Created by wangyang on 2017/3/23.
//  Copyright © 2017年 更美互动信息科技有限公司. All rights reserved.
//

#import "GMSafeValue.h"

@implementation GMSafeValue
+ (id)safeValue:(id)object {
    return object ?: [NSNull null];
}

+ (NSString *)safeString:(id)str {
    if ([str isKindOfClass:[NSNumber class]]) {
        return ((NSNumber *)str).stringValue;
    }
    return str ?: @"";
}

+ (NSNumber *)safeNumber:(id)num {
    if ([num isKindOfClass:[NSString class]]) {
        return @(((NSString *)num).integerValue);
    }
    return num ?: @0;
}

+ (nullable NSString *)nullableString:(id)str {
    if ([str isKindOfClass:[NSNumber class]]) {
        return ((NSNumber *)str).stringValue;
    }
    return str ?: nil;
}

+ (nullable NSNumber *)nullableNumber:(id)num {
    if ([num isKindOfClass:[NSString class]]) {
        return @(((NSString *)num).integerValue);
    }
    return num ?: nil;
}
@end

