//
//  GMAlbumListViewController.h
//  Gengmei
//
//  Created by Q14 on 2018/9/28.
//  Copyright © 2018年 更美互动信息科技有限公司. All rights reserved.
//

#import <UIKit/UIKit.h>
#import "GMAlbumModel.h"
#import "GMPhotoManager.h"
@class GMAlbumListViewController;

typedef void (^ GMAlbumListViewControllerDidDoneBlock)(NSArray<GMPhotoModel *> *allList, NSArray<GMPhotoModel *> *photoList, NSArray<GMPhotoModel *> *videoList, NSArray<UIImage *> *imageList, BOOL original, GMAlbumListViewController *viewController);
typedef void (^ GMAlbumListViewControllerDidCancelBlock)(GMAlbumListViewController *viewController);

@protocol GMAlbumListViewControllerDelegate <NSObject>
@optional

/**
 点击取消
 
 @param albumListViewController self
 */
- (void)albumListViewControllerDidCancel:(GMAlbumListViewController *)albumListViewController;

/**
 点击完成时获取图片image完成后的回调
 选中了原图返回的就是原图
 需 requestImageAfterFinishingSelection = YES 才会有回调
 
 @param albumListViewController self
 @param imageList 图片数组
 */
- (void)albumListViewController:(GMAlbumListViewController *)albumListViewController didDoneAllImage:(NSArray<UIImage *> *)imageList;

/**
 点击完成
 
 @param albumListViewController self
 @param allList 已选的所有列表(包含照片、视频)
 @param photoList 已选的照片列表
 @param videoList 已选的视频列表
 @param original 是否原图
 */
- (void)albumListViewController:(GMAlbumListViewController *)albumListViewController didDoneAllList:(NSArray<GMPhotoModel *> *)allList photos:(NSArray<GMPhotoModel *> *)photoList videos:(NSArray<GMPhotoModel *> *)videoList original:(BOOL)original;
@end

@interface GMAlbumListViewController : WMBaseViewController

@property (nonatomic, weak) id<GMAlbumListViewControllerDelegate> delegate;
@property (nonatomic, strong) GMPhotoManager *manager;
@property (nonatomic, copy) GMAlbumListViewControllerDidDoneBlock doneBlock;
@property (nonatomic, copy) GMAlbumListViewControllerDidCancelBlock cancelBlock;
@end


@interface GMAlbumListQuadrateViewCell : UICollectionViewCell
@property (strong, nonatomic) GMAlbumModel *model;
- (void)cancelRequest ;
@end

@interface GMAlbumListSingleViewCell : UITableViewCell
@property (strong, nonatomic) GMAlbumModel *model;
- (void)cancelRequest ;
@end
