//
//  GMCustomAssetModel.m
//  Gengmei
//
//  Created by Q14 on 2018/9/28.
//  Copyright © 2018年 更美互动信息科技有限公司. All rights reserved.
//

#import "GMCustomAssetModel.h"
@interface GMCustomAssetModel ()
@property (copy, nonatomic) NSString *localImageName;
@end

@implementation GMCustomAssetModel
+ (instancetype)assetWithLocaImageName:(NSString *)imageName selected:(BOOL)selected {
    return [[self alloc] initAssetWithLocaImageName:imageName selected:selected];
}

- (instancetype)initAssetWithLocaImageName:(NSString *)imageName selected:(BOOL)selected {
    self = [super init];
    if (self) {
        self.type = GMCustomAssetModelTypeLocalImage;
        self.localImageName = imageName;
        self.localImage = [UIImage imageNamed:imageName];
        self.selected = selected;
    }
    return self;
}

+ (instancetype)assetWithLocalImage:(UIImage *)image selected:(BOOL)selected {
    return [[self alloc] initAssetWithLocalImage:image selected:selected];
}

- (instancetype)initAssetWithLocalImage:(UIImage *)image selected:(BOOL)selected {
    self = [super init];
    if (self) {
        self.type = GMCustomAssetModelTypeLocalImage;
        self.localImage = image;
        self.selected = selected;
    }
    return self;
}

+ (instancetype)assetWithNetworkImageURL:(NSURL *)imageURL selected:(BOOL)selected {
    return [[self alloc] initAssetWithNetworkImageURL:imageURL selected:selected];
}

- (instancetype)initAssetWithNetworkImageURL:(NSURL *)imageURL selected:(BOOL)selected {
    self = [super init];
    if (self) {
        self.type = GMCustomAssetModelTypeNetWorkImage;
        self.networkImageURL = imageURL;
        self.selected = selected;
    }
    return self;
}

+ (instancetype)assetWithLocalVideoURL:(NSURL *)videoURL selected:(BOOL)selected {
    return [[self alloc] initAssetWithLocalVideoURL:videoURL selected:selected];
}

- (instancetype)initAssetWithLocalVideoURL:(NSURL *)videoURL selected:(BOOL)selected {
    self = [super init];
    if (self) {
        self.type = GMCustomAssetModelTypeLocalVideo;
        self.localVideoURL = videoURL;
        self.selected = selected;
    }
    return self;
}
@end
