//
//  GMCustomCameraViewController.h
//  Gengmei
//
//  Created by Q14 on 2018/9/29.
//  Copyright © 2018年 更美互动信息科技有限公司. All rights reserved.
//

#import <UIKit/UIKit.h>
#import <AVFoundation/AVFoundation.h>

typedef NS_ENUM(NSUInteger, GMCustomCameraBottomViewMode) {
    GMCustomCameraBottomViewModePhoto = 0,
    GMCustomCameraBottomViewModeVideo = 1,
};
@class GMPhotoManager,GMCustomCameraViewController,GMPhotoModel;
typedef void (^ GMCustomCameraViewControllerDidDoneBlock)(GMPhotoModel *model, GMCustomCameraViewController *viewController);
typedef void (^ GMCustomCameraViewControllerDidCancelBlock)(GMCustomCameraViewController *viewController);

@protocol GMCustomCameraViewControllerDelegate <NSObject>
@optional
- (void)customCameraViewController:(GMCustomCameraViewController *)viewController didDone:(GMPhotoModel *)model;
- (void)customCameraViewControllerDidCancel:(GMCustomCameraViewController *)viewController;
@end
@interface GMCustomCameraViewController : UIViewController
@property (weak, nonatomic) id<GMCustomCameraViewControllerDelegate> delegate;
@property (strong, nonatomic) GMPhotoManager *manager;
@property (assign, nonatomic) BOOL isOutside;
@property (copy, nonatomic) GMCustomCameraViewControllerDidDoneBlock doneBlock;
@property (copy, nonatomic) GMCustomCameraViewControllerDidCancelBlock cancelBlock;
@end

@protocol GMCustomCameraBottomViewDelegate <NSObject>
@optional
- (void)playViewClick;
- (void)playViewAnimateCompletion;
- (void)playViewChangeMode:(GMCustomCameraBottomViewMode)mode;
@end

@interface GMCustomCameraBottomView : UIView
@property (weak, nonatomic) id<GMCustomCameraBottomViewDelegate> delegate;
@property (assign ,nonatomic) BOOL animating;
@property (assign, nonatomic) GMCustomCameraBottomViewMode mode;
- (instancetype)initWithFrame:(CGRect)frame manager:(GMPhotoManager *)manager isOutside:(BOOL)isOutside;
- (void)changeTime:(NSInteger)time;
- (void)startRecord;
- (void)stopRecord;
- (void)beganAnimate;
- (void)leftAnimate;
- (void)rightAnimate;
@end

@interface GMCustomCameraPlayVideoView : UIView
@property (strong, nonatomic) NSURL *videoURL;
@property (strong, nonatomic) AVPlayerLayer *playerLayer;
- (void)stopPlay;
@end
