//
//  GMCustomPreviewView.h
//  Gengmei
//
//  Created by Q14 on 2018/9/29.
//  Copyright © 2018年 更美互动信息科技有限公司. All rights reserved.
//

#import <UIKit/UIKit.h>
#import <AVFoundation/AVFoundation.h>

@protocol GMCustomPreviewViewDelegate <NSObject>
@optional;
- (void)tappedToFocusAtPoint:(CGPoint)point;
- (void)pinchGestureScale:(CGFloat)scale;
- (void)didLeftSwipeClick;
- (void)didRightSwipeClick;
@end

@interface GMCustomPreviewView : UIView
@property (strong, nonatomic) AVCaptureSession *session;
@property (weak, nonatomic) id<GMCustomPreviewViewDelegate> delegate;

@property(nonatomic,assign) CGFloat beginGestureScale;
@property(nonatomic,assign) CGFloat effectiveScale;
@property(nonatomic,assign) CGFloat maxScale;

- (void)addSwipeGesture;

@property (nonatomic) BOOL tapToFocusEnabled;
@property (nonatomic) BOOL tapToExposeEnabled;
@property (nonatomic) BOOL pinchToZoomEnabled;
@end

