//
//  GMDatePhotoEditViewController.h
//  GMAlbum
//
//  Created by Q14 on 2018/10/8.
//  Copyright © 2018年 Q14. All rights reserved.
//

#import <UIKit/UIKit.h>
#import "GMPhotoModel.h"
#import "GMPhotoManager.h"

@class GMDatePhotoEditViewController;
@protocol GMDatePhotoEditViewControllerDelegate <NSObject>
@optional
- (void)datePhotoEditViewControllerDidClipClick:(GMDatePhotoEditViewController *)datePhotoEditViewController beforeModel:(GMPhotoModel *)beforeModel afterModel:(GMPhotoModel *)afterModel;
@end

@interface GMDatePhotoEditViewController : UIViewController
@property (weak, nonatomic) id<GMDatePhotoEditViewControllerDelegate> delegate;
@property (strong, nonatomic) GMPhotoModel *model;
@property (strong, nonatomic) GMPhotoManager *manager;
@property (assign, nonatomic) BOOL outside;
@end


@class GMEditRatio;
@protocol GMDatePhotoEditBottomViewDelegate <NSObject>
@optional
- (void)bottomViewDidCancelClick;
- (void)bottomViewDidRestoreClick;
- (void)bottomViewDidRotateClick;
- (void)bottomViewDidClipClick;
- (void)bottomViewDidSelectRatioClick:(GMEditRatio *)ratio;
@end

@interface GMDatePhotoEditBottomView : UIView
@property (nonatomic, weak) id<GMDatePhotoEditBottomViewDelegate> delegate;
@property (assign, nonatomic) BOOL enabled;
- (instancetype)initWithManager:(GMPhotoManager *)manager;
@end

@interface GMEditGridLayer : CALayer
@property (nonatomic, assign) CGRect clippingRect;
@property (nonatomic, strong) UIColor *bgColor;
@property (nonatomic, strong) UIColor *gridColor;
@end

@interface GMEditCornerView : UIView
@property (nonatomic, strong) UIColor *bgColor;
@end

@interface GMEditRatio : NSObject
@property (nonatomic, assign) BOOL isLandscape;
@property (nonatomic, readonly) CGFloat ratio;
@property (nonatomic, strong) NSString *titleFormat;
- (id)initWithValue1:(CGFloat)value1 value2:(CGFloat)value2;
@end
