//
//  GMDatePhotoPreviewViewController.h
//  Gengmei
//
//  Created by Q14 on 2018/9/29.
//  Copyright © 2018年 更美互动信息科技有限公司. All rights reserved.
//

#import <UIKit/UIKit.h>
#import <PhotosUI/PhotosUI.h>
#import "GMPhotoManager.h"

@class GMDatePhotoPreviewViewController,GMDatePhotoPreviewBottomView,GMDatePhotoPreviewViewCell,GMPhotoView;
@protocol GMDatePhotoPreviewViewControllerDelegate <NSObject>
@optional
- (void)datePhotoPreviewControllerDidSelect:(GMDatePhotoPreviewViewController *)previewController model:(GMPhotoModel *)model;
- (void)datePhotoPreviewControllerDidDone:(GMDatePhotoPreviewViewController *)previewController;
- (void)datePhotoPreviewDidEditClick:(GMDatePhotoPreviewViewController *)previewController;
- (void)datePhotoPreviewSingleSelectedClick:(GMDatePhotoPreviewViewController *)previewController model:(GMPhotoModel *)model;
- (void)datePhotoPreviewDownLoadICloudAssetComplete:(GMDatePhotoPreviewViewController *)previewController model:(GMPhotoModel *)model;
- (void)datePhotoPreviewSelectLaterDidEditClick:(GMDatePhotoPreviewViewController *)previewController beforeModel:(GMPhotoModel *)beforeModel afterModel:(GMPhotoModel *)afterModel;
- (void)datePhotoPreviewDidDeleteClick:(GMDatePhotoPreviewViewController *)previewController deleteModel:(GMPhotoModel *)model deleteIndex:(NSInteger)index;
@end

@interface GMDatePhotoPreviewViewController : WMBaseViewController<UIViewControllerTransitioningDelegate,UINavigationControllerDelegate>
@property (weak, nonatomic) id<GMDatePhotoPreviewViewControllerDelegate> delegate;
@property (strong, nonatomic) GMPhotoManager *manager;
@property (strong, nonatomic) NSMutableArray *modelArray;
@property (assign, nonatomic) NSInteger currentModelIndex;
@property (assign, nonatomic) BOOL outside;
@property (assign, nonatomic) BOOL selectPreview;
@property (strong, nonatomic) UICollectionView *collectionView;
@property (strong, nonatomic) GMDatePhotoPreviewBottomView *bottomView;
@property (strong, nonatomic) GMPhotoView *photoView;
@property (assign, nonatomic) BOOL previewShowDeleteButton;
@property (assign, nonatomic) BOOL stopCancel;
/**  预览大图时是否禁用手势返回  */
@property (assign, nonatomic) BOOL disableaPersentInteractiveTransition;
- (GMDatePhotoPreviewViewCell *)currentPreviewCell:(GMPhotoModel *)model;
- (void)setSubviewAlphaAnimate:(BOOL)animete duration:(NSTimeInterval)duration;
@end


@interface GMDatePhotoPreviewViewCell : UICollectionViewCell
@property (assign, nonatomic) BOOL stopCancel;
@property (strong, nonatomic) GMPhotoModel *model;
@property (strong, nonatomic, readonly) UIImageView *imageView;
@property (strong, nonatomic, readonly) AVPlayerLayer *playerLayer;
@property (strong, nonatomic, readonly) UIImage *gifImage;
@property (strong, nonatomic) UIButton *videoPlayBtn;
@property (assign, nonatomic) BOOL dragging;
@property (nonatomic, copy) void (^cellTapClick)(void);
@property (nonatomic, copy) void (^cellDidPlayVideoBtn)(BOOL play);
@property (nonatomic, copy) void (^cellDownloadICloudAssetComplete)(GMDatePhotoPreviewViewCell *myCell);
- (void)againAddImageView;
- (void)resetScale;
- (void)requestHDImage;
- (void)cancelRequest;
@end

