//
//  GMDatePhotoToolManager.h
//  GMAlbum
//
//  Created by Q4 on 2018/10/7.
//  Copyright © 2018年 Q14. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "GMPhotoModel.h"
#import <UIKit/UIKit.h>

typedef enum : NSUInteger {
    GMDatePhotoToolManagerRequestTypeHD = 0, // 高清
    GMDatePhotoToolManagerRequestTypeOriginal // 原图
} GMDatePhotoToolManagerRequestType;

typedef void (^ GMDatePhotoToolManagerSuccessHandler)(NSArray<NSURL *> *allURL,NSArray<NSURL *> *photoURL, NSArray<NSURL *> *videoURL);
typedef void (^ GMDatePhotoToolManagerFailedHandler)(void);

typedef void (^ GMDatePhotoToolManagerGetImageListSuccessHandler)(NSArray<UIImage *> *imageList);
typedef void (^ GMDatePhotoToolManagerGetImageListFailedHandler)(void);

typedef void (^ GMDatePhotoToolManagerGetImageDataListSuccessHandler)(NSArray<NSData *> *imageDataList);
typedef void (^ GMDatePhotoToolManagerGetImageDataListFailedHandler)(void);

@interface GMDatePhotoToolManager : NSObject
/**
将选择的模型数组写入临时目录 -   GMDatePhotoToolManagerRequestTypeHD

注意!!!!
如果有网络图片时,对应的URL为该网络图片的地址。顺序下标与网络图片在模型数组的下标一致
也可以根据 http || https 来判断是否网络图片

@param modelList 模型数组
@param success 成功回调
@param failed 失败回调
*/
- (void)writeSelectModelListToTempPathWithList:(NSArray<GMPhotoModel *> *)modelList
                                       success:(GMDatePhotoToolManagerSuccessHandler)success
                                        failed:(GMDatePhotoToolManagerFailedHandler)failed;

/**
 将选择的模型数组写入临时目录
 
 注意!!!!
 如果有网络图片时,对应的URL为该网络图片的地址。顺序下标与网络图片在模型数组的下标一致
 也可以根据 http || https 来判断是否网络图片
 
 @param modelList 模型数组
 @param requestType 请求类型
 @param success 成功回调
 @param failed 失败回调
 */
- (void)writeSelectModelListToTempPathWithList:(NSArray<GMPhotoModel *> *)modelList
                                   requestType:(GMDatePhotoToolManagerRequestType)requestType
                                       success:(GMDatePhotoToolManagerSuccessHandler)success
                                        failed:(GMDatePhotoToolManagerFailedHandler)failed;

/**
 根据模型数组获取与之对应的image数组   -   GMDatePhotoToolManagerRequestTypeHD
 如果有网络图片时，会先判断是否已经下载完成了，未下载完则重新下载。
 @param modelList 模型数组
 @param success 成功
 @param failed 失败
 */
- (void)getSelectedImageList:(NSArray<GMPhotoModel *> *)modelList
                     success:(GMDatePhotoToolManagerGetImageListSuccessHandler)success
                      failed:(GMDatePhotoToolManagerGetImageListFailedHandler)failed;

/**
 根据模型数组获取与之对应的image数组
 如果有网络图片时，会先判断是否已经下载完成了，未下载完则重新下载。
 @param modelList 模型数组
 @param requestType 请求类型
 @param success 成功回调
 @param failed 失败回调
 */
- (void)getSelectedImageList:(NSArray<GMPhotoModel *> *)modelList
                 requestType:(GMDatePhotoToolManagerRequestType)requestType
                     success:(GMDatePhotoToolManagerGetImageListSuccessHandler)success
                      failed:(GMDatePhotoToolManagerGetImageListFailedHandler)failed;

/**
 取消获取image
 */
- (void)cancelGetImageList;

//- (void)getSelectedImagePath:(NSArray<GMPhotoModel *> *)modelList success:(GMDatePhotoToolManagerGetImagePathSuccessHandler)success failed:(GMDatePhotoToolManagerGetImagePathFailedHandler)failed;

/**
 根据模型数组获取与之对应的NSData数组
 如果有网络图片时，会先判断是否已经下载完成了，未下载完则重新下载。
 
 @param modelList 模型数组
 @param success 成功
 @param failed 失败
 */
- (void)getSelectedImageDataList:(NSArray<GMPhotoModel *> *)modelList
                         success:(GMDatePhotoToolManagerGetImageDataListSuccessHandler)success
                          failed:(GMDatePhotoToolManagerGetImageDataListFailedHandler)failed;

- (void)gifModelAssignmentData:(NSArray<GMPhotoModel *> *)gifModelArray
                       success:(void (^)(void))success
                        failed:(void (^)(void))failed;
@end

