//
//  GMDatePhotoViewController.h
//  Gengmei
//
//  Created by Q14 on 2018/9/28.
//  Copyright © 2018年 更美互动信息科技有限公司. All rights reserved.
//

#import <UIKit/UIKit.h>
#import "GMPhotoModel.h"
#import "GMDatePhotoViewFlowLayout.h"

@class GMDatePhotoViewController,GMDatePhotoViewCell,GMDatePhotoBottomView,GMCustomCameraController;
@protocol GMDatePhotoViewControllerDelegate <NSObject>
@optional
/**
 点击取消
 
 @param datePhotoViewController self
 */
- (void)datePhotoViewControllerDidCancel:(GMDatePhotoViewController *)datePhotoViewController;

/**
 点击完成按钮
 
 @param datePhotoViewController self
 @param allList 已选的所有列表(包含照片、视频)
 @param photoList 已选的照片列表
 @param videoList 已选的视频列表
 @param original 是否原图
 */
- (void)datePhotoViewController:(GMDatePhotoViewController *)datePhotoViewController didDoneAllList:(NSArray<GMPhotoModel *> *)allList photos:(NSArray<GMPhotoModel *> *)photoList videos:(NSArray<GMPhotoModel *> *)videoList original:(BOOL)original;

/**
 改变了选择
 
 @param model 改的模型
 @param selected 是否选中
 */
- (void)datePhotoViewControllerDidChangeSelect:(GMPhotoModel *)model selected:(BOOL)selected;
@end
@interface GMDatePhotoViewController : WMBaseViewController
@property (weak, nonatomic) id<GMDatePhotoViewControllerDelegate> delegate;
@property (strong, nonatomic) GMPhotoManager *manager;
@property (strong, nonatomic) GMAlbumModel *albumModel;
- (GMDatePhotoViewCell *)currentPreviewCell:(GMPhotoModel *)model;
- (BOOL)scrollToModel:(GMPhotoModel *)model;
- (void)scrollToPoint:(GMDatePhotoViewCell *)cell rect:(CGRect)rect;
@end

@protocol GMDatePhotoViewCellDelegate <NSObject>
@optional
- (void)datePhotoViewCell:(GMDatePhotoViewCell *)cell didSelectBtn:(UIButton *)selectBtn;
- (void)datePhotoViewCellRequestICloudAssetComplete:(GMDatePhotoViewCell *)cell;
@end

@interface GMDatePhotoViewCell : UICollectionViewCell
@property (weak, nonatomic) id<GMDatePhotoViewCellDelegate> delegate;
@property (assign, nonatomic) NSInteger section;
@property (assign, nonatomic) NSInteger item;
@property (strong, nonatomic, readonly) UIImageView *imageView;
@property (strong, nonatomic) CALayer *selectMaskLayer;
@property (strong, nonatomic) GMPhotoModel *model;
@property (assign, nonatomic) BOOL singleSelected;
@property (strong, nonatomic) UIColor *selectBgColor;
@property (strong, nonatomic) UIColor *selectedTitleColor;
- (void)cancelRequest;
- (void)startRequestICloudAsset;
- (void)bottomViewPrepareAnimation;
- (void)bottomViewStartAnimation;
@end

@interface GMDatePhotoCameraViewCell : UICollectionViewCell
@property (strong, nonatomic) GMPhotoModel *model;
@property (strong, nonatomic, readonly) GMCustomCameraController *cameraController;
- (void)starRunning;
- (void)stopRunning;
@end
@interface GMDatePhotoViewSectionHeaderView : UICollectionReusableView
@property (strong, nonatomic) GMPhotoDateModel *model;
@property (assign, nonatomic) BOOL changeState;
@property (assign, nonatomic) BOOL translucent;
@property (strong, nonatomic) UIColor *suspensionBgColor;
@property (strong, nonatomic) UIColor *suspensionTitleColor;
@end

@interface GMDatePhotoViewSectionFooterView : UICollectionReusableView
@property (assign, nonatomic) NSInteger photoCount;
@property (assign, nonatomic) NSInteger videoCount;
@end

@protocol GMDatePhotoBottomViewDelegate <NSObject>
@optional
- (void)datePhotoBottomViewDidPreviewBtn;
- (void)datePhotoBottomViewDidDoneBtn;
- (void)datePhotoBottomViewDidEditBtn;
@end

@interface GMDatePhotoBottomView : UIView
@property (weak, nonatomic) id<GMDatePhotoBottomViewDelegate> delegate;
@property (strong, nonatomic) GMPhotoManager *manager;
@property (assign, nonatomic) BOOL previewBtnEnabled;
@property (assign, nonatomic) BOOL doneBtnEnabled;
@property (assign, nonatomic) NSInteger selectCount;
@property (strong, nonatomic) UIButton *originalBtn;
@property (strong, nonatomic) UIToolbar *bgView;
@end
