//
//  GMPhotoConfiguration.h
//  Gengmei
//
//  Created by Q14 on 2018/9/28.
//  Copyright © 2018年 更美互动信息科技有限公司. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <UIKit/UIKit.h>

typedef NS_ENUM(NSUInteger, GMPhotoConfigurationCameraType) {
    GMPhotoConfigurationCameraTypePhoto = 0,        // 拍照
    GMPhotoConfigurationCameraTypeVideo = 1,        // 录制
    GMPhotoConfigurationCameraTypeTypePhotoAndVideo // 拍照和录制一起
};

@class GMPhotoManager;
@class GMPhotoModel;
@interface GMPhotoConfiguration : NSObject

/**
 是否展示按日期拆分逻辑
 */
@property (nonatomic, assign) BOOL isShowSpiltAlert;

/**
 是否按照日期拆分默认为NO
 */
@property (nonatomic, assign) BOOL isSpiltDate;
/**
 模型数组保存草稿时存在本地的文件名称 default GMPhotoPickerModelArray
 如果有多个地方保存了草稿请设置不同的fileName
 */
@property (copy, nonatomic) NSString *localFileName;

/**
 在照片列表选择照片完后点击完成时是否请求图片
 选中了原图则是原图，没选中则是高清图
 并赋值给model的 thumbPhoto 和 previewPhoto 属性
 */
@property (assign, nonatomic) BOOL requestImageAfterFinishingSelection;
/**
 照片是否可以编辑   default YES
 */
@property (assign, nonatomic) BOOL photoCanEdit;
/**
 是否替换相机控制器
 使用自己的相机时需要调用下面两个block
 */
@property (assign, nonatomic) BOOL replaceCameraViewController;

/**
 是否可移动的裁剪框
 */
@property (assign, nonatomic) BOOL movableCropBox;
/**
 小图照片清晰度 越大越清晰、越消耗性能
 设置太大的话获取图片资源时耗时长且内存消耗大可能会引起界面卡顿
 default：[UIScreen mainScreen].bounds.size.width
 320    ->  0.8
 375    ->  1.4
 other  ->  1.7
 */
@property (assign, nonatomic) CGFloat clarityScale;
/**
 可移动的裁剪框是否可以编辑大小
 */
@property (assign, nonatomic) BOOL movableCropBoxEditSize;
/**
可移动裁剪框的比例 (w,h)
一定要是宽比高哦!!!
当 movableCropBox = YES && movableCropBoxEditSize = YES
如果不设置比例即可自由编辑大小
*/
@property (assign, nonatomic) CGPoint movableCropBoxCustomRatio;
/**
 将要跳转相机界面 在block内实现跳转
 demo1 里有示例（使用的是系统相机）
 */
@property (copy, nonatomic) void (^shouldUseCamera)(UIViewController *viewController, GMPhotoConfigurationCameraType cameraType, GMPhotoManager *manager);

/**
 相机拍照完成调用这个block 传入模型
 */
@property (copy, nonatomic) void (^useCameraComplete)(GMPhotoModel *model);


#pragma mark - < UI相关 >
/**
 显示底部照片详细信息 default YES
 */
@property (assign, nonatomic) BOOL showBottomPhotoDetail;

//主题颜色
@property (nonatomic, strong) UIColor *themeColor;
/**
 cell选中时的背景颜色
 */
@property (strong, nonatomic) UIColor *cellSelectedBgColor;

/**
 cell选中时的文字颜色
 */
@property (strong, nonatomic) UIColor *cellSelectedTitleColor;

/**
 选中时数字的颜色
 */
@property (strong, nonatomic) UIColor *selectedTitleColor;
/**
 sectionHeader悬浮时的标题颜色 ios9以上才有效果
 */
@property (strong, nonatomic) UIColor *sectionHeaderSuspensionTitleColor;

/**
 sectionHeader悬浮时的背景色 ios9以上才有效果
 */
@property (strong, nonatomic) UIColor *sectionHeaderSuspensionBgColor;

/**
 导航栏标题颜色
 */
@property (strong, nonatomic) UIColor *navigationTitleColor;

/**
 导航栏背景颜色
 */
@property (strong, nonatomic) UIColor *navBarBackgroudColor;

/**
 headerSection 半透明毛玻璃效果  默认YES  ios9以上才有效果
 */
@property (assign, nonatomic) BOOL sectionHeaderTranslucent;
/**
 是否需要显示日期section  默认YES
 */
@property (assign, nonatomic) BOOL showDateSectionHeader;
/**
 照片列表按日期倒序 默认 NO
 */
@property (assign, nonatomic) BOOL reverseDate;

/**
 原图按钮普通状态下的按钮图标名
 */
@property (copy, nonatomic) NSString *originalNormalImageName;

/**
 原图按钮选中状态下的按钮图标名
 */
@property (copy, nonatomic) NSString *originalSelectedImageName;

#pragma mark - < 基本配置 >
/**
 相册列表每行多少个照片 默认4个 iphone 4s / 5  默认3个
 */
@property (assign, nonatomic) NSInteger rowCount;

/**
 最大选择数 等于 图片最大数 + 视频最大数 默认10 - 必填
 */
@property (assign, nonatomic) NSInteger maxNum;

/**
 图片最大选择数 默认9 - 必填
 */
@property (assign, nonatomic) NSInteger photoMaxNum;

/**
 视频最大选择数 // 默认1 - 必填
 */
@property (assign, nonatomic) NSInteger videoMaxNum;

/**
 是否打开相机功能
 */
@property (assign, nonatomic) BOOL openCamera;

/**
 是否开启查看GIF图片功能 - 默认开启
 */
@property (assign, nonatomic) BOOL lookGifPhoto;

/**
 是否开启查看LivePhoto功能呢 - 默认 NO
 */
@property (assign, nonatomic) BOOL lookLivePhoto;

/**
 图片和视频是否能够同时选择 默认支持
 */
@property (assign, nonatomic) BOOL selectTogether;
/**
 相机视频录制最大秒数  -  默认60s
 */
@property (assign, nonatomic) NSTimeInterval videoMaximumDuration;

/**
 *  删除临时的照片/视频 -
 注:相机拍摄的照片并没有保存到系统相册 或 是本地图片
 如果当这样的照片都没有被选中时会清空这些照片 有一张选中了就不会删..
 - 默认 YES
 */
@property (assign, nonatomic) BOOL deleteTemporaryPhoto;

/**
 *  拍摄的 照片/视频 是否保存到系统相册  默认NO
 *  支持添加到自定义相册 - (需9.0以上)
 */
@property (assign, nonatomic) BOOL saveSystemAblum;

/**
 拍摄的照片/视频保存到指定相册的名称  默认 BundleName
 (需9.0以上系统才可以保存到自定义相册 , 以下的系统只保存到相机胶卷...)
 */
@property (copy, nonatomic) NSString *customAlbumName;

/**
 *  视频能选择的最大秒数  -  默认 3分钟/180秒
 */
@property (assign, nonatomic) NSTimeInterval videoMaxDuration;

/**
 是否为单选模式 默认 NO
 会自动过滤掉gif、livephoto
 */
@property (assign, nonatomic) BOOL singleSelected;

/**
 单选模式下选择图片时是否直接跳转到编辑界面  - 默认 YES
 */
@property (assign, nonatomic) BOOL singleJumpEdit;

/**
 是否开启3DTouch预览功能 默认 YES
 */
@property (assign, nonatomic) BOOL open3DTouchPreview;

/**
 下载iCloud上的资源  默认YES
 */
@property (assign, nonatomic) BOOL downloadICloudAsset;

/**
 是否过滤iCloud上的资源 默认NO
 */
@property (assign, nonatomic) BOOL filtrationICloudAsset;


#pragma mark - < block返回的视图 >
/**
 设置导航栏
 */
@property (copy, nonatomic) void (^navigationBar)(UINavigationBar *navigationBar);
/**
 相册列表的collectionView
 - 旋转屏幕时也会调用
 */
@property (copy, nonatomic) void(^albumListCollectionView)(UICollectionView *collectionView);

/**
 相册列表的tableView
 - 旋转屏幕时也会调用
 */
@property (copy, nonatomic) void(^albumListTableView)(UITableView *tableView);

/**
 相片列表的collectionView
 - 旋转屏幕时也会调用
 */
@property (copy, nonatomic) void(^photoListCollectionView)(UICollectionView *collectionView);

/**
 预览界面的collectionView
 - 旋转屏幕时也会调用
 */
@property (copy, nonatomic) void(^previewCollectionView)(UICollectionView *collectionView);
@end
