//
//  GMPhotoConfiguration.m
//  Gengmei
//
//  Created by Q14 on 2018/9/28.
//  Copyright © 2018年 更美互动信息科技有限公司. All rights reserved.
//

#import "GMPhotoConfiguration.h"

@implementation GMPhotoConfiguration
- (instancetype)init {
    self = [super init];
    if (self) {
        [self setup];
    }
    return self;
}

- (void)setup {
    self.open3DTouchPreview = YES;
    self.openCamera = YES;
    self.lookLivePhoto = NO;
    self.lookGifPhoto = YES;
    self.selectTogether = YES;
    self.maxNum = 50;
    self.photoMaxNum = 40;
    self.videoMaxNum = 10;
    self.isSpiltDate = NO;
    self.rowCount = 4;
    self.showBottomPhotoDetail = NO;
    self.downloadICloudAsset = YES;
    self.videoMaxDuration = 8 * 60.f;
    self.videoMaximumDuration = 60.f;
    self.deleteTemporaryPhoto = YES;
    self.showDateSectionHeader = YES;
    self.requestImageAfterFinishingSelection = YES;
    self.customAlbumName = [NSBundle mainBundle].infoDictionary[(NSString *)kCFBundleNameKey];
    self.sectionHeaderTranslucent = YES;
    
     if ([UIScreen mainScreen].bounds.size.width == 320) {
        self.clarityScale = 0.8;
    }else if ([UIScreen mainScreen].bounds.size.width == 375) {
        self.clarityScale = 1.4;
    }else {
        self.clarityScale = 1.7;
    }
    
    self.singleJumpEdit = YES;
    self.photoCanEdit = YES;
    self.localFileName = @"GMPhotoPickerModelArray";
}

- (void)setClarityScale:(CGFloat)clarityScale {
    if (clarityScale <= 0.f) {
        if ([UIScreen mainScreen].bounds.size.width == 320) {
            _clarityScale = 0.8;
        }else if ([UIScreen mainScreen].bounds.size.width == 375) {
            _clarityScale = 1.4;
        }else {
            _clarityScale = 1.7;
        }
    }else {
        _clarityScale = clarityScale;
    }
}
- (UIColor *)themeColor {
    if (!_themeColor) {
        _themeColor = [UIColor colorWithRed:0 green:0.478431 blue:1 alpha:1];
    }
    return _themeColor;
}
- (NSString *)originalNormalImageName {
    if (!_originalNormalImageName) {
        _originalNormalImageName = @"gm_original_normal@2x.png";
        //如果后期放在k私有库里面记得修改
//        [GMPhotoTools gm_imageNamed:_originalNormalImageName];
    }
    return _originalNormalImageName;
}
- (NSString *)originalSelectedImageName {
    if (!_originalSelectedImageName) {
        _originalSelectedImageName = @"gm_original_selected@2x.png";
        //如果后期放在k私有库里面记得修改 文件名
//        [GMPhotoTools gm_imageNamed:_originalSelectedImageName];
    }
    return _originalSelectedImageName;
}
- (void)setVideoMaximumDuration:(NSTimeInterval)videoMaximumDuration {
    if (videoMaximumDuration <= 3) {
        videoMaximumDuration = 4;
    }
    _videoMaximumDuration = videoMaximumDuration;
}
- (CGPoint)movableCropBoxCustomRatio {
    return _movableCropBoxCustomRatio;
}
@end
