//
//  GMPhotoDefine.h
//  Gengmei
//
//  Created by Q14 on 2018/9/28.
//  Copyright © 2018年 更美互动信息科技有限公司. All rights reserved.
//

#ifndef GMPhotoDefine_h
#define GMPhotoDefine_h

#define RGBCOLOR_HEX(hexColor) [UIColor colorWithRed: (((hexColor >> 16) & 0xFF))/255.0f         \
green: (((hexColor >> 8) & 0xFF))/255.0f             \
blue: ((hexColor & 0xFF))/255.0f                    \
alpha: 1]
// 判断iPhone X
#define kDevice_Is_iPhoneX ([UIScreen instancesRespondToSelector:@selector(currentMode)] ? CGSizeEqualToSize(CGSizeMake(1125, 2436), [[UIScreen mainScreen] currentMode].size) : NO)

// 导航栏 + 状态栏 的高度
#define kNavigationBarHeight (kDevice_Is_iPhoneX ? 88 : 64)
#define kTopMargin (kDevice_Is_iPhoneX ? 44 : 0)
#define kBottomMargin (kDevice_Is_iPhoneX ? 34 : 0)

#define iOS11_Later ([UIDevice currentDevice].systemVersion.floatValue >= 11.0f)

#define iOS9Later ([UIDevice currentDevice].systemVersion.floatValue >= 9.1f)

#define iOS9_Later ([UIDevice currentDevice].systemVersion.floatValue >= 9.0f)

#define iOS8_2Later ([UIDevice currentDevice].systemVersion.floatValue >= 8.2f)
#define GMEncodeKey @"GMModelArray"
// 弱引用
#define GMWeakSelf __weak typeof(self) weakSelf = self;

CG_INLINE UIAlertController * gm_showAlert(UIViewController *vc,
                                           NSString *title,
                                           NSString *message,
                                           NSString *buttonTitle1,
                                           NSString *buttonTitle2,
                                           dispatch_block_t buttonTitle1Handler,
                                           dispatch_block_t buttonTitle2Handler) {
    UIAlertController *alertController = [UIAlertController alertControllerWithTitle:title
                                                                             message:message
                                                                      preferredStyle:UIAlertControllerStyleAlert];
    UIAlertAction *cancelAction = [UIAlertAction actionWithTitle:buttonTitle1
                                                           style:UIAlertActionStyleCancel
                                                         handler:^(UIAlertAction * _Nonnull action) {
                                                             if (buttonTitle1Handler) buttonTitle1Handler();
                                                         }];
    [alertController addAction:cancelAction];
    
    UIAlertAction *okAction = [UIAlertAction actionWithTitle:buttonTitle2
                                                       style:UIAlertActionStyleDefault
                                                     handler:^(UIAlertAction * _Nonnull action) {
                                                         if (buttonTitle2Handler) buttonTitle2Handler();
                                                     }];
    [alertController addAction:okAction];
    
    [vc presentViewController:alertController animated:YES completion:nil];
    return alertController;
}

#endif /* GMPhotoDefine_h */
