//
//  GMPhotoDemoViewController.m
//  Gengmei
//
//  Created by Q14 on 2018/9/28.
//  Copyright © 2018年 更美互动信息科技有限公司. All rights reserved.
//

#import "GMPhotoDemoViewController.h"
#import <SystemConfiguration/CaptiveNetwork.h>
#import "GMPhotoDefine.h"
#import "GMPhotoManager.h"
#import "GMPhotoTools.h"
#import "UIViewController+GMExtension.h"
//#import <CoreServices/CoreServices.h>

@interface GMPhotoDemoViewController ()
@property (strong, nonatomic) GMPhotoManager *manager;
@end

@implementation GMPhotoDemoViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    self.view.backgroundColor = UIColor.whiteColor;
    UIButton *button = [UIButton buttonWithType:UIButtonTypeCustom];
    [button setBackgroundColor:[UIColor blackColor]];
    [button addTarget:self action:@selector(goAlbum:) forControlEvents:UIControlEventTouchUpInside];
    [button setTitle:@"点我选图片" forState:UIControlStateNormal];
    button.frame = CGRectMake(100, 200, 200, 20);
    [self.view addSubview:button];

}


- (GMPhotoManager *)manager
{
    if (!_manager) {
        _manager = [[GMPhotoManager alloc] initWithType:GMPhotoManagerSelectedTypePhoto];
        _manager.configuration.videoMaxNum = 5;
        _manager.configuration.deleteTemporaryPhoto = NO;
        _manager.configuration.lookLivePhoto = YES;
        _manager.configuration.saveSystemAblum = YES;
        _manager.configuration.themeColor = self.view.tintColor;
        _manager.configuration.navigationBar = ^(UINavigationBar *navigationBar) {
        };
        _manager.configuration.requestImageAfterFinishingSelection = YES;
        __weak typeof(self) weakSelf = self;

        _manager.configuration.albumListCollectionView = ^(UICollectionView *collectionView) {
        };
        _manager.configuration.photoListCollectionView = ^(UICollectionView *collectionView) {
        };
        _manager.configuration.previewCollectionView = ^(UICollectionView *collectionView) {
        };
        _manager.configuration.movableCropBox = YES;
        _manager.configuration.movableCropBoxEditSize = YES;
        _manager.configuration.movableCropBoxCustomRatio = CGPointMake(1, 1);
        
        self.manager.type = GMPhotoManagerSelectedTypePhotoAndVideo;
        // 使用自动的相机  这里拿系统相机做示例
        _manager.configuration.shouldUseCamera = ^(UIViewController *viewController, GMPhotoConfigurationCameraType cameraType, GMPhotoManager *manager) {
            
            // 这里拿使用系统相机做例子
            UIImagePickerController *imagePickerController = [[UIImagePickerController alloc] init];
            imagePickerController.delegate = (id)weakSelf;
            imagePickerController.allowsEditing = NO;
            NSString *requiredMediaTypeImage = ( NSString *)kUTTypeImage;
            NSString *requiredMediaTypeMovie = ( NSString *)kUTTypeMovie;
            NSArray *arrMediaTypes;
            if (cameraType == GMPhotoConfigurationCameraTypePhoto) {
                arrMediaTypes=[NSArray arrayWithObjects:requiredMediaTypeImage,nil];
            }else if (cameraType == GMPhotoConfigurationCameraTypeVideo) {
                arrMediaTypes=[NSArray arrayWithObjects:requiredMediaTypeMovie,nil];
            }else {
                arrMediaTypes=[NSArray arrayWithObjects:requiredMediaTypeImage, requiredMediaTypeMovie,nil];
            }
            [imagePickerController setMediaTypes:arrMediaTypes];
            // 设置录制视频的质量
            [imagePickerController setVideoQuality:UIImagePickerControllerQualityTypeHigh];
            //设置最长摄像时间
            [imagePickerController setVideoMaximumDuration:60.f];
            imagePickerController.sourceType = UIImagePickerControllerSourceTypeCamera;
            imagePickerController.navigationController.navigationBar.tintColor = [UIColor whiteColor];
            imagePickerController.modalPresentationStyle=UIModalPresentationOverCurrentContext;
            [viewController presentViewController:imagePickerController animated:YES completion:nil];
        };
        
//        _manager.configuration.videoCanEdit = NO;
        _manager.configuration.photoCanEdit = NO;
    }
    return _manager;
}
- (void)imagePickerController:(UIImagePickerController *)picker didFinishPickingMediaWithInfo:(NSDictionary<NSString *,id> *)info {
    [picker dismissViewControllerAnimated:YES completion:nil];
    
    NSString *mediaType = [info objectForKey:UIImagePickerControllerMediaType];
    GMPhotoModel *model;
    if ([mediaType isEqualToString:(NSString *)kUTTypeImage]) {
        UIImage *image = [info objectForKey:UIImagePickerControllerOriginalImage];
        model = [GMPhotoModel photoModelWithImage:image];
        if (self.manager.configuration.saveSystemAblum) {
            [GMPhotoTools savePhotoToCustomAlbumWithName:self.manager.configuration.customAlbumName photo:model.thumbPhoto];
        }
    }else  if ([mediaType isEqualToString:(NSString *)kUTTypeMovie]) {
        NSURL *url = info[UIImagePickerControllerMediaURL];
        NSDictionary *opts = [NSDictionary dictionaryWithObject:[NSNumber numberWithBool:NO]
                                                         forKey:AVURLAssetPreferPreciseDurationAndTimingKey];
        AVURLAsset *urlAsset = [AVURLAsset URLAssetWithURL:url options:opts];
        float second = 0;
        second = urlAsset.duration.value/urlAsset.duration.timescale;
        model = [GMPhotoModel photoModelWithVideoURL:url videoTime:second];
        if (self.manager.configuration.saveSystemAblum) {
            [GMPhotoTools saveVideoToCustomAlbumWithName:self.manager.configuration.customAlbumName videoURL:url];
        }
    }
    if (self.manager.configuration.useCameraComplete) {
        self.manager.configuration.useCameraComplete(model);
    }
}
- (void)imagePickerControllerDidCancel:(UIImagePickerController *)picker {
    [picker dismissViewControllerAnimated:YES completion:nil];
}


- (void)goAlbum:(UIButton *)sender {

    self.manager.configuration.themeColor = self.view.tintColor;
    self.manager.configuration.cellSelectedTitleColor = nil;
    
    self.manager.configuration.navBarBackgroudColor = nil;

    self.manager.configuration.sectionHeaderTranslucent = YES;

    self.manager.configuration.cellSelectedBgColor = [[UIColor whiteColor] colorWithAlphaComponent:0.44];
    self.manager.configuration.selectedTitleColor = nil;
    self.manager.configuration.sectionHeaderSuspensionBgColor = nil;
    self.manager.configuration.sectionHeaderSuspensionTitleColor = nil;
    
    self.manager.configuration.photoMaxNum = 50;
    self.manager.configuration.videoMaxNum = 10;
    self.manager.configuration.rowCount = 4;

    self.manager.configuration.reverseDate = YES;
    self.manager.configuration.openCamera = YES;

    
    [self gm_presentAlbumListViewControllerWithManager:self.manager done:^(NSArray<GMPhotoModel *> *allList, NSArray<GMPhotoModel *> *photoList, NSArray<GMPhotoModel *> *videoList, NSArray<UIImage *> *imageList, BOOL original, GMAlbumListViewController *viewController) {

        NSLog(@"all - %@",allList);
        NSLog(@"photo - %@",photoList);
        NSLog(@"video - %@",videoList);
        NSLog(@"image - %@",imageList);
    } cancel:^(GMAlbumListViewController *viewController) {
        NSLog(@"取消了");
    }];
}

@end
