//
//  GMPhotoManager.m
//  Gengmei
//
//  Created by Q14 on 2018/9/28.
//  Copyright © 2018年 更美互动信息科技有限公司. All rights reserved.
//

#import "GMPhotoManager.h"
#import "GMPhotoTools.h"
#import "GMPhotoDefine.h"

@interface GMPhotoManager ()<PHPhotoLibraryChangeObserver>
@property (nonatomic, strong) NSMutableArray *allPhotos;
@property (nonatomic, strong) NSMutableArray *allVideos;
@property (nonatomic, strong) NSMutableArray *allObjs;
//@property (nonatomic, assign) BOOL hasLivePhoto;
//------// 当要删除的已选中的图片或者视频的时候需要在对应的end数组里面删除
// 例如: 如果删除的是通过相机拍的照片需要在 endCameraList 和 endCameraPhotos 数组删除对应的图片模型
@property (nonatomic, strong) NSMutableArray *selectedList;
@property (nonatomic, strong) NSMutableArray *selectedPhotos;
@property (nonatomic, strong) NSMutableArray *selectedVideos;
@property (nonatomic, strong) NSMutableArray *cameraList;
@property (nonatomic, strong) NSMutableArray *cameraPhotos;
@property (nonatomic, strong) NSMutableArray *cameraVideos;
@property (nonatomic, strong) NSMutableArray *endCameraList;
@property (nonatomic, strong) NSMutableArray *endCameraPhotos;
@property (nonatomic, strong) NSMutableArray *endCameraVideos;
@property (nonatomic, strong) NSMutableArray *selectedCameraList;
@property (nonatomic, strong) NSMutableArray *selectedCameraPhotos;
@property (nonatomic, strong) NSMutableArray *selectedCameraVideos;
@property (nonatomic, strong) NSMutableArray *endSelectedCameraList;
@property (nonatomic, strong) NSMutableArray *endSelectedCameraPhotos;
@property (nonatomic, strong) NSMutableArray *endSelectedCameraVideos;
@property (nonatomic, strong) NSMutableArray *endSelectedList;
@property (nonatomic, strong) NSMutableArray *endSelectedPhotos;
@property (nonatomic, strong) NSMutableArray *endSelectedVideos;
//------//
@property (nonatomic, assign) BOOL isOriginal;
@property (nonatomic, assign) BOOL endIsOriginal;
@property (nonatomic, copy) NSString *photosTotalBtyes;
@property (nonatomic, copy) NSString *endPhotosTotalBtyes;
@property (nonatomic, strong) NSMutableArray *iCloudUploadArray;
@property (nonatomic, strong) NSMutableArray *albums;
@property (nonatomic, assign) BOOL firstHasCameraAsset;
@end

@implementation GMPhotoManager
#pragma mark - < 初始化 >
- (instancetype)initWithType:(GMPhotoManagerSelectedType)type {
    if (self = [super init]) {
        self.type = type;
        [self setup];
    }
    return self;
}
- (instancetype)init {
    if ([super init]) {
        self.type = GMPhotoManagerSelectedTypePhoto;
        [self setup];
    }
    return self;
}
- (void)setup {
    self.albums = [NSMutableArray array];
    self.selectedList = [NSMutableArray array];
    self.selectedPhotos = [NSMutableArray array];
    self.selectedVideos = [NSMutableArray array];
    self.endSelectedList = [NSMutableArray array];
    self.endSelectedPhotos = [NSMutableArray array];
    self.endSelectedVideos = [NSMutableArray array];
    self.cameraList = [NSMutableArray array];
    self.cameraPhotos = [NSMutableArray array];
    self.cameraVideos = [NSMutableArray array];
    self.endCameraList = [NSMutableArray array];
    self.endCameraPhotos = [NSMutableArray array];
    self.endCameraVideos = [NSMutableArray array];
    self.selectedCameraList = [NSMutableArray array];
    self.selectedCameraPhotos = [NSMutableArray array];
    self.selectedCameraVideos = [NSMutableArray array];
    self.endSelectedCameraList = [NSMutableArray array];
    self.endSelectedCameraPhotos = [NSMutableArray array];
    self.endSelectedCameraVideos = [NSMutableArray array];
    self.iCloudUploadArray = [NSMutableArray array];
}
- (GMPhotoConfiguration *)configuration {
    if (!_configuration) {
        _configuration = [[GMPhotoConfiguration alloc] init];
    }
    return _configuration;
}
- (void)setLocalImageList:(NSArray *)localImageList {
    _localImageList = localImageList;
    if (!localImageList.count) return;
    if (![localImageList.firstObject isKindOfClass:[UIImage class]]) {
//        (@"请传入装着UIImage对象的数组");
    
        return;
    }
    for (UIImage *image in localImageList) {
        GMPhotoModel *photoModel = [GMPhotoModel photoModelWithImage:image];
        photoModel.selected = YES;
        [self.endCameraPhotos addObject:photoModel];
        [self.endSelectedCameraPhotos addObject:photoModel];
        [self.endCameraList addObject:photoModel];
        [self.endSelectedCameraList addObject:photoModel];
        [self.endSelectedPhotos addObject:photoModel];
        [self.endSelectedList addObject:photoModel];
    }
}
- (void)addCustomAssetModel:(NSArray<GMCustomAssetModel *> *)assetArray {
    if (!assetArray.count) return;
    if (![assetArray.firstObject isKindOfClass:[GMCustomAssetModel class]]) {
     NSLog(@"请传入装着GMCustomAssetModel对象的数组");
        return;
    }
    self.configuration.deleteTemporaryPhoto = NO;
    NSInteger photoMaxCount = self.configuration.photoMaxNum;
    NSInteger videoMaxCount = self.configuration.videoMaxNum;
    NSInteger photoCount = 0;
    NSInteger videoCount = 0;
    BOOL canAddPhoto;
    BOOL canAddVideo;
    BOOL selectTogether = self.configuration.selectTogether;
    GMPhotoModel *firstModel;
    for (GMCustomAssetModel *model in assetArray) {
        canAddPhoto = !(photoCount >= photoMaxCount);
        canAddVideo = !(videoCount >= videoMaxCount);
        if (!selectTogether && firstModel) {
            if (firstModel.subType == GMPhotoModelMediaSubTypePhoto) {
                canAddVideo = NO;
            }else if (firstModel.subType == GMPhotoModelMediaSubTypeVideo) {
                canAddPhoto = NO;
            }
        }
        if (model.type == GMCustomAssetModelTypeLocalImage && model.localImage) {
            if (self.type == GMPhotoModelMediaSubTypeVideo) {
                continue;
            }
            GMPhotoModel *photoModel = [GMPhotoModel photoModelWithImage:model.localImage];
            photoModel.selected = canAddPhoto ? model.selected : NO;
            if (model.selected && canAddPhoto) {
                [self.endCameraPhotos addObject:photoModel];
                [self.endSelectedCameraPhotos addObject:photoModel];
                [self.endCameraList addObject:photoModel];
                [self.endSelectedCameraList addObject:photoModel];
                [self.endSelectedPhotos addObject:photoModel];
                [self.endSelectedList addObject:photoModel];
                firstModel = photoModel;
                photoCount++;
            }else {
                [self.endCameraPhotos addObject:photoModel];
                [self.endCameraList addObject:photoModel];
            }
        }else if (model.type == GMCustomAssetModelTypeNetWorkImage && model.networkImageURL) {
            if (self.type == GMPhotoModelMediaSubTypeVideo) {
                continue;
            }
            GMPhotoModel *photoModel = [GMPhotoModel photoModelWithImageURL:model.networkImageURL];
            photoModel.selected = canAddPhoto ? model.selected : NO;
            if (model.selected && canAddPhoto) {
                [self.endCameraPhotos addObject:photoModel];
                [self.endSelectedCameraPhotos addObject:photoModel];
                [self.endCameraList addObject:photoModel];
                [self.endSelectedCameraList addObject:photoModel];
                [self.endSelectedPhotos addObject:photoModel];
                [self.endSelectedList addObject:photoModel];
                firstModel = photoModel;
                photoCount++;
            }else {
                [self.endCameraPhotos addObject:photoModel];
                [self.endCameraList addObject:photoModel];
            }
        }else if (model.type == GMCustomAssetModelTypeLocalVideo) {
            if (self.type == GMPhotoModelMediaSubTypePhoto) {
                continue;
            }
            // 本地视频
            GMPhotoModel *photoModel = [GMPhotoModel photoModelWithVideoURL:model.localVideoURL];
            photoModel.selected = canAddVideo ? model.selected : NO;
            if (model.selected && canAddVideo) {
                [self.endCameraVideos addObject:photoModel];
                [self.endSelectedCameraVideos addObject:photoModel];
                [self.endCameraList addObject:photoModel];
                [self.endSelectedCameraList addObject:photoModel];
                [self.endSelectedVideos addObject:photoModel];
                [self.endSelectedList addObject:photoModel];
                firstModel = photoModel;
                videoCount++;
            }else {
                [self.endCameraVideos addObject:photoModel];
                [self.endCameraList addObject:photoModel];
            }
        }
    }
}
- (void)addNetworkingImageToAlbum:(NSArray<NSString *> *)imageUrls selected:(BOOL)selected {
    if (!imageUrls.count) return;
    if (![imageUrls.firstObject isKindOfClass:[NSString class]]) {
        return;
    }
    self.configuration.deleteTemporaryPhoto = NO;
    for (NSString *imageUrlStr in imageUrls) {
        GMPhotoModel *photoModel = [GMPhotoModel photoModelWithImageURL:[NSURL URLWithString:imageUrlStr]];
        photoModel.selected = selected;
        if (selected) {
            [self.endCameraPhotos addObject:photoModel];
            [self.endSelectedCameraPhotos addObject:photoModel];
            [self.endCameraList addObject:photoModel];
            [self.endSelectedCameraList addObject:photoModel];
            [self.endSelectedPhotos addObject:photoModel];
            [self.endSelectedList addObject:photoModel];
        }else {
            [self.endCameraPhotos addObject:photoModel];
            [self.endCameraList addObject:photoModel];
        }
    }
}
- (void)setNetworkPhotoUrls:(NSArray<NSString *> *)networkPhotoUrls {
    _networkPhotoUrls = networkPhotoUrls;
    if (!networkPhotoUrls.count) return;
    if (![networkPhotoUrls.firstObject isKindOfClass:[NSString class]]) {
//        if (showLog) NSSLog(@"请传入装着NSString对象的数组");
        return;
    }
    self.configuration.deleteTemporaryPhoto = NO;
    for (NSString *imageUrlStr in networkPhotoUrls) {
        GMPhotoModel *photoModel = [GMPhotoModel photoModelWithImageURL:[NSURL URLWithString:imageUrlStr]];
        photoModel.selected = NO;
        [self.endCameraPhotos addObject:photoModel];
        [self.endCameraList addObject:photoModel];
    }
}
- (void)addModelArray:(NSArray<GMPhotoModel *> *)modelArray {
    if (!modelArray.count) return;
    if (![modelArray.firstObject isKindOfClass:[GMPhotoModel class]]) {
//        if (showLog) NSSLog(@"请传入装着GMPhotoModel对象的数组");
        return;
    }
    for (GMPhotoModel *photoModel in modelArray) {
        if (photoModel.subType == GMPhotoModelMediaSubTypePhoto) {
            [self.endSelectedPhotos addObject:photoModel];
        }else {
            [self.endSelectedVideos addObject:photoModel];
        }
        if (photoModel.type == GMPhotoModelMediaTypeCameraPhoto) {
            [self.endCameraPhotos addObject:photoModel];
            [self.endSelectedCameraPhotos addObject:photoModel];
            [self.endCameraList addObject:photoModel];
            [self.endSelectedCameraList addObject:photoModel];
        }else if (photoModel.type == GMPhotoModelMediaTypeCameraVideo) {
            [self.endCameraVideos addObject:photoModel];
            [self.endSelectedCameraVideos addObject:photoModel];
            [self.endCameraList addObject:photoModel];
            [self.endSelectedCameraList addObject:photoModel];
        }
        [self.endSelectedList addObject:photoModel];
    }
}
- (void)addLocalVideo:(NSArray<NSURL *> *)urlArray selected:(BOOL)selected {
    if (!urlArray.count) return;
    if (![urlArray.firstObject isKindOfClass:[NSURL class]]) {
//        if (showLog) NSSLog(@"请传入装着NSURL对象的数组");
        return;
    }
    self.configuration.deleteTemporaryPhoto = NO;
    for (NSURL *url in urlArray) {
        GMPhotoModel *model = [GMPhotoModel photoModelWithVideoURL:url];
        model.selected = selected;
        if (selected) {
            [self.endCameraVideos addObject:model];
            [self.endSelectedCameraVideos addObject:model];
            [self.endCameraList addObject:model];
            [self.endSelectedCameraList addObject:model];
            [self.endSelectedVideos addObject:model];
            [self.endSelectedList addObject:model];
        }else {
            [self.endCameraVideos addObject:model];
            [self.endCameraList addObject:model];
        }
    }
}
- (void)addLocalImage:(NSArray *)images selected:(BOOL)selected {
    if (!images.count) return;
    if (![images.firstObject isKindOfClass:[UIImage class]]) {
//        if (showLog) NSSLog(@"请传入装着UIImage对象的数组");
        return;
    }
    self.configuration.deleteTemporaryPhoto = NO;
    for (UIImage *image in images) {
        GMPhotoModel *photoModel = [GMPhotoModel photoModelWithImage:image];
        photoModel.selected = selected;
        if (selected) {
            [self.endCameraPhotos addObject:photoModel];
            [self.endSelectedCameraPhotos addObject:photoModel];
            [self.endCameraList addObject:photoModel];
            [self.endSelectedCameraList addObject:photoModel];
            [self.endSelectedPhotos addObject:photoModel];
            [self.endSelectedList addObject:photoModel];
        }else {
            [self.endCameraPhotos addObject:photoModel];
            [self.endCameraList addObject:photoModel];
        }
    }
}
- (void)addLocalImageToAlbumWithImages:(NSArray *)images {
    if (!images.count) return;
    if (![images.firstObject isKindOfClass:[UIImage class]]) {
//        if (showLog) NSSLog(@"请传入装着UIImage对象的数组");
        return;
    }
    self.configuration.deleteTemporaryPhoto = NO;
    for (UIImage *image in images) {
        GMPhotoModel *photoModel = [GMPhotoModel photoModelWithImage:image];
        [self.endCameraPhotos addObject:photoModel];
        [self.endCameraList addObject:photoModel];
    }
}
/**
 获取系统所有相册
 
 @param albums 相册集合
 */
- (void)getAllPhotoAlbums:(void(^)(GMAlbumModel *firstAlbumModel))firstModel albums:(void(^)(NSArray *albums))albums isFirst:(BOOL)isFirst {
    // 获取系统智能相册
    PHFetchResult *smartAlbums = [PHAssetCollection fetchAssetCollectionsWithType:PHAssetCollectionTypeSmartAlbum subtype:PHAssetCollectionSubtypeAlbumRegular options:nil];
    
    if (self.firstHasCameraAsset &&
        self.configuration.saveSystemAblum &&
        !smartAlbums.count &&
        [PHPhotoLibrary authorizationStatus] == PHAuthorizationStatusAuthorized) {
        if (!self.albums.count && self.cameraList.count) {
            GMPhotoModel *photoMd = self.cameraList.firstObject;
            GMAlbumModel *albumModel = [[GMAlbumModel alloc] init];
            albumModel.count = self.cameraList.count;
            albumModel.albumName = @"所有照片";//[NSBundle GM_localizedStringForKey:@"所有照片"];
            albumModel.index = 0;
            albumModel.tempImage = photoMd.thumbPhoto;
            [self.albums addObject:albumModel];
            if (albums) {
                albums(self.albums);
            }
            if (isFirst) {
                if (firstModel) {
                    firstModel(albumModel);
                }
            }
            self.firstHasCameraAsset = NO;
            return;
        }
    }
    if (self.albums.count > 0) [self.albums removeAllObjects];
    [self.iCloudUploadArray removeAllObjects];
    
    [smartAlbums enumerateObjectsWithOptions:NSEnumerationConcurrent usingBlock:^(PHAssetCollection *collection, NSUInteger idx, BOOL * _Nonnull stop) {
        if (isFirst) {
            if ([[GMPhotoTools transFormPhotoTitle:collection.localizedTitle] isEqualToString:@"相机胶卷"] || [[GMPhotoTools transFormPhotoTitle:collection.localizedTitle] isEqualToString:@"所有照片"]) {
                
                // 是否按创建时间排序
                PHFetchOptions *option = [[PHFetchOptions alloc] init];
                option.sortDescriptors = @[[NSSortDescriptor sortDescriptorWithKey:@"creationDate" ascending:YES]];
                if (self.type == GMPhotoManagerSelectedTypePhoto) {
                    option.predicate = [NSPredicate predicateWithFormat:@"mediaType == %ld", PHAssetMediaTypeImage];
                }else if (self.type == GMPhotoManagerSelectedTypeVideo) {
                    option.predicate = [NSPredicate predicateWithFormat:@"mediaType == %ld", PHAssetMediaTypeVideo];
                }
                // 获取照片集合
                PHFetchResult *result = [PHAsset fetchAssetsInAssetCollection:collection options:option];
                //                if (result.count) {
                GMAlbumModel *albumModel = [[GMAlbumModel alloc] init];
                albumModel.count = result.count;
                albumModel.albumName = collection.localizedTitle;
                albumModel.result = result;
                albumModel.index = 0;
                if (firstModel) {
                    firstModel(albumModel);
                }
                *stop = YES;
                //                }
            }
        }else {
            // 是否按创建时间排序
            PHFetchOptions *option = [[PHFetchOptions alloc] init];
            option.sortDescriptors = @[[NSSortDescriptor sortDescriptorWithKey:@"creationDate" ascending:YES]];
            if (self.type == GMPhotoManagerSelectedTypePhoto) {
                option.predicate = [NSPredicate predicateWithFormat:@"mediaType == %ld", PHAssetMediaTypeImage];
            }else if (self.type == GMPhotoManagerSelectedTypeVideo) {
                option.predicate = [NSPredicate predicateWithFormat:@"mediaType == %ld", PHAssetMediaTypeVideo];
            }
            // 获取照片集合
            PHFetchResult *result = [PHAsset fetchAssetsInAssetCollection:collection options:option];
            
            // 过滤掉空相册
            if (result.count > 0 && ![[GMPhotoTools transFormPhotoTitle:collection.localizedTitle] isEqualToString:@"最近删除"]) {
                GMAlbumModel *albumModel = [[GMAlbumModel alloc] init];
                albumModel.count = result.count;
                albumModel.albumName = collection.localizedTitle;
                albumModel.result = result;
                if ([[GMPhotoTools transFormPhotoTitle:collection.localizedTitle] isEqualToString:@"相机胶卷"] || [[GMPhotoTools transFormPhotoTitle:collection.localizedTitle] isEqualToString:@"所有照片"]) {
                    [self.albums insertObject:albumModel atIndex:0];
                }else {
                    [self.albums addObject:albumModel];
                }
            }
        }
    }];
    if (isFirst) {
        if (!smartAlbums.count &&
            [PHPhotoLibrary authorizationStatus] == PHAuthorizationStatusAuthorized) {
            GMPhotoModel *photoMd = self.cameraList.firstObject;
            GMAlbumModel *albumModel = [[GMAlbumModel alloc] init];
            albumModel.count = self.cameraList.count;
            albumModel.albumName = @"所有照片";
            albumModel.index = 0;
            albumModel.tempImage = photoMd.thumbPhoto;
            [self.albums addObject:albumModel];
            if (albums) {
                albums(self.albums);
            }
            if (firstModel) {
                firstModel(albumModel);
            }
        }
        return;
    }
    // 获取用户相册
    PHFetchResult *userAlbums = [PHAssetCollection fetchAssetCollectionsWithType:PHAssetCollectionTypeAlbum subtype:PHAssetCollectionSubtypeSmartAlbumUserLibrary options:nil];
    [userAlbums enumerateObjectsWithOptions:NSEnumerationConcurrent usingBlock:^(PHAssetCollection *collection, NSUInteger idx, BOOL * _Nonnull stop) {
        // 是否按创建时间排序
        PHFetchOptions *option = [[PHFetchOptions alloc] init];
        option.sortDescriptors = @[[NSSortDescriptor sortDescriptorWithKey:@"creationDate" ascending:YES]];
        if (self.type == GMPhotoManagerSelectedTypePhoto) {
            option.predicate = [NSPredicate predicateWithFormat:@"mediaType == %ld", PHAssetMediaTypeImage];
        }else if (self.type == GMPhotoManagerSelectedTypeVideo) {
            option.predicate = [NSPredicate predicateWithFormat:@"mediaType == %ld", PHAssetMediaTypeVideo];
        }
        // 获取照片集合
        PHFetchResult *result = [PHAsset fetchAssetsInAssetCollection:collection options:option];
        
        // 过滤掉空相册
        if (result.count > 0) {
            GMAlbumModel *albumModel = [[GMAlbumModel alloc] init];
            albumModel.count = result.count;
            albumModel.albumName = [GMPhotoTools transFormPhotoTitle:collection.localizedTitle];
            albumModel.result = result;
            [self.albums addObject:albumModel];
        }
    }];
    for (int i = 0 ; i < self.albums.count; i++) {
        GMAlbumModel *model = self.albums[i];
        model.index = i;
    }
    if (!self.albums.count &&
        [PHPhotoLibrary authorizationStatus] == PHAuthorizationStatusAuthorized) {
        GMPhotoModel *photoMd = self.cameraList.firstObject;
        GMAlbumModel *albumModel = [[GMAlbumModel alloc] init];
        albumModel.count = self.cameraList.count;
        albumModel.albumName = @"所有照片";
        albumModel.index = 0;
        albumModel.tempImage = photoMd.thumbPhoto;
        [self.albums addObject:albumModel];
    }
    if (albums) {
        albums(self.albums);
    }
}

/**
 *  是否为同一天
 */
- (BOOL)isSameDay:(NSDate*)date1 date2:(NSDate*)date2 {
    NSCalendar* calendar = [NSCalendar currentCalendar];
    
    unsigned unitFlags = NSCalendarUnitYear | NSCalendarUnitMonth |  NSCalendarUnitDay;
    NSDateComponents* comp1 = [calendar components:unitFlags fromDate:date1];
    NSDateComponents* comp2 = [calendar components:unitFlags fromDate:date2];
    
    return [comp1 day]   == [comp2 day] &&
    [comp1 month] == [comp2 month] &&
    [comp1 year]  == [comp2 year];
}
- (void)getPhotoListWithAlbumModel:(GMAlbumModel *)albumModel complete:(void (^)(NSArray *allList , NSArray *previewList,NSArray *photoList ,NSArray *videoList ,NSArray *dateList , GMPhotoModel *firstSelectModel))complete {
    NSMutableArray *allArray = [NSMutableArray array];
    NSMutableArray *previewArray = [NSMutableArray array];
    NSMutableArray *videoArray = [NSMutableArray array];
    NSMutableArray *photoArray = [NSMutableArray array];
    NSMutableArray *dateArray = [NSMutableArray array];
    
    __block NSDate *currentIndexDate;
    __block NSMutableArray *sameDayArray;
    __block GMPhotoDateModel *dateModel;
    __block GMPhotoModel *firstSelectModel;
    __block BOOL already = NO;
    NSMutableArray *selectList = [NSMutableArray arrayWithArray:self.selectedList];
    if (self.configuration.reverseDate) {
        [albumModel.result enumerateObjectsWithOptions:NSEnumerationReverse usingBlock:^(PHAsset *asset, NSUInteger idx, BOOL * _Nonnull stop) {
            GMPhotoModel *photoModel = [[GMPhotoModel alloc] init];
            photoModel.clarityScale = self.configuration.clarityScale;
            photoModel.asset = asset;
            if ([[asset valueForKey:@"isCloudPlaceholder"] boolValue]) {
                if (self.iCloudUploadArray.count) {

                    NSPredicate *pred = [NSPredicate predicateWithFormat:@"localIdentifier = %@", asset.localIdentifier];
                    NSArray *newArray = [self.iCloudUploadArray filteredArrayUsingPredicate:pred];
                    if (!newArray.count) {
                    }
                }else {
                }
            }
            if (selectList.count > 0) {
                NSPredicate *pred = [NSPredicate predicateWithFormat:@"localIdentifier = %@", asset.localIdentifier];
                NSArray *newArray = [selectList filteredArrayUsingPredicate:pred];
                if (newArray.count > 0) {
                    GMPhotoModel *model = newArray.firstObject;
                    [selectList removeObject:model];
                    photoModel.selected = YES;
                    if ((model.type == GMPhotoModelMediaTypePhoto || model.type == GMPhotoModelMediaTypePhotoGif) || (model.type == GMPhotoModelMediaTypeLivePhoto || model.type == GMPhotoModelMediaTypeCameraPhoto)) {
                        if (model.type == GMPhotoModelMediaTypeCameraPhoto) {
                            [self.selectedCameraPhotos replaceObjectAtIndex:[self.selectedCameraPhotos indexOfObject:model] withObject:photoModel];
                        }else {
                            [self.selectedPhotos replaceObjectAtIndex:[self.selectedPhotos indexOfObject:model] withObject:photoModel];
                        }
                    }else {
                        if (model.type == GMPhotoModelMediaTypeCameraVideo) {
                            [self.selectedCameraVideos replaceObjectAtIndex:[self.selectedCameraVideos indexOfObject:model] withObject:photoModel];
                        }else {
                            [self.selectedVideos replaceObjectAtIndex:[self.selectedVideos indexOfObject:model] withObject:photoModel];
                        }
                    }
                    [self.selectedList replaceObjectAtIndex:[self.selectedList indexOfObject:model] withObject:photoModel];
                    photoModel.thumbPhoto = model.thumbPhoto;
                    photoModel.previewPhoto = model.previewPhoto;
                    photoModel.selectIndexStr = model.selectIndexStr;
                    if (!firstSelectModel) {
                        firstSelectModel = photoModel;
                    }
                }
            }
            if (asset.mediaType == PHAssetMediaTypeImage) {
                photoModel.subType = GMPhotoModelMediaSubTypePhoto;
                if ([[asset valueForKey:@"filename"] hasSuffix:@"GIF"]) {
                    if (self.configuration.singleSelected) {
                        photoModel.type = GMPhotoModelMediaTypePhoto;
                    }else {
                        photoModel.type = self.configuration.lookGifPhoto ? GMPhotoModelMediaTypePhotoGif : GMPhotoModelMediaTypePhoto;
                    }
                }else if (asset.mediaSubtypes == PHAssetMediaSubtypePhotoLive){
                    if (iOS9Later) {
                        if (!self.configuration.singleSelected) {
                            photoModel.type = self.configuration.lookLivePhoto ? GMPhotoModelMediaTypeLivePhoto : GMPhotoModelMediaTypePhoto;
                        }else {
                            photoModel.type = GMPhotoModelMediaTypePhoto;
                        }
                    }else {
                        photoModel.type = GMPhotoModelMediaTypePhoto;
                    }
                }else {
                    photoModel.type = GMPhotoModelMediaTypePhoto;
                }
                [photoArray addObject:photoModel];
            }else if (asset.mediaType == PHAssetMediaTypeVideo) {
                photoModel.subType = GMPhotoModelMediaSubTypeVideo;
                photoModel.type = GMPhotoModelMediaTypeVideo;
                [videoArray addObject:photoModel];
                // 默认视频都是可选的
                [self changeModelVideoState:photoModel];
            }
            photoModel.currentAlbumIndex = albumModel.index;
            
            BOOL canAddPhoto = YES;
            if (self.configuration.filtrationICloudAsset) {

                    canAddPhoto = NO;
            }else {
                [allArray addObject:photoModel];
                [previewArray addObject:photoModel];
            }
            
            if (self.configuration.showDateSectionHeader && canAddPhoto) {
                NSDate *photoDate = photoModel.creationDate;
                if (!currentIndexDate) {
                    dateModel = [[GMPhotoDateModel alloc] init];
                    dateModel.date = photoDate;
                    sameDayArray = [NSMutableArray array];
                    [sameDayArray addObject:photoModel];
                    [dateArray addObject:dateModel];
                    photoModel.dateItem = sameDayArray.count - 1;
                    photoModel.dateSection = dateArray.count - 1;
                }else {
                    if ([self isSameDay:photoDate date2:currentIndexDate]) {
                        [sameDayArray addObject:photoModel];
                        photoModel.dateItem = sameDayArray.count - 1;
                        photoModel.dateSection = dateArray.count - 1;
                    }else {
                        dateModel.photoModelArray = sameDayArray;
                        sameDayArray = [NSMutableArray array];
                        dateModel = [[GMPhotoDateModel alloc] init];
                        dateModel.date = photoDate;
                        [sameDayArray addObject:photoModel];
                        [dateArray addObject:dateModel];
                        photoModel.dateItem = sameDayArray.count - 1;
                        photoModel.dateSection = dateArray.count - 1;
                    }
                }
                if (firstSelectModel && !already) {
                    firstSelectModel.dateSection = dateArray.count - 1;
                    firstSelectModel.dateItem = sameDayArray.count - 1;
                    already = YES;
                }
                if (idx == 0) {
                    dateModel.photoModelArray = sameDayArray;
                }
                if (!dateModel.location) {
                    if (photoModel.asset.location) {
                        dateModel.location = photoModel.asset.location;
                    }
                }
                currentIndexDate = photoDate;
            }else {
                photoModel.dateItem = allArray.count - 1;
                photoModel.dateSection = 0;
            }
        }];
    }else {
        NSInteger index = 0;
        for (PHAsset *asset in albumModel.result) {
            GMPhotoModel *photoModel = [[GMPhotoModel alloc] init];
            photoModel.asset = asset;
            photoModel.clarityScale = self.configuration.clarityScale;
            if ([[asset valueForKey:@"isCloudPlaceholder"] boolValue]) {
                if (self.iCloudUploadArray.count) {
                    NSPredicate *pred = [NSPredicate predicateWithFormat:@"localIdentifier = %@", asset.localIdentifier];
                    NSArray *newArray = [self.iCloudUploadArray filteredArrayUsingPredicate:pred];
                    if (!newArray.count) {
                    }
                }else {
                }
            }
            if (selectList.count > 0) {
                NSPredicate *pred = [NSPredicate predicateWithFormat:@"localIdentifier = %@", asset.localIdentifier];
                NSArray *newArray = [selectList filteredArrayUsingPredicate:pred];
                if (newArray.count > 0) {
                    GMPhotoModel *model = newArray.firstObject;
                    [selectList removeObject:model];
                    photoModel.selected = YES;
                    if ((model.type == GMPhotoModelMediaTypePhoto || model.type == GMPhotoModelMediaTypePhotoGif) || (model.type == GMPhotoModelMediaTypeLivePhoto || model.type == GMPhotoModelMediaTypeCameraPhoto)) {
                        if (model.type == GMPhotoModelMediaTypeCameraPhoto) {
                            [self.selectedCameraPhotos replaceObjectAtIndex:[self.selectedCameraPhotos indexOfObject:model] withObject:photoModel];
                        }else {
                            [self.selectedPhotos replaceObjectAtIndex:[self.selectedPhotos indexOfObject:model] withObject:photoModel];
                        }
                    }else {
                        if (model.type == GMPhotoModelMediaTypeCameraVideo) {
                            [self.selectedCameraVideos replaceObjectAtIndex:[self.selectedCameraVideos indexOfObject:model] withObject:photoModel];
                        }else {
                            [self.selectedVideos replaceObjectAtIndex:[self.selectedVideos indexOfObject:model] withObject:photoModel];
                        }
                    }
                    [self.selectedList replaceObjectAtIndex:[self.selectedList indexOfObject:model] withObject:photoModel];
                    photoModel.thumbPhoto = model.thumbPhoto;
                    photoModel.previewPhoto = model.previewPhoto;
                    photoModel.selectIndexStr = model.selectIndexStr;
                    if (!firstSelectModel) {
                        firstSelectModel = photoModel;
                    }
                }
            }
            if (asset.mediaType == PHAssetMediaTypeImage) {
                photoModel.subType = GMPhotoModelMediaSubTypePhoto;
                if ([[asset valueForKey:@"filename"] hasSuffix:@"GIF"]) {
                    if (self.configuration.singleSelected) {
                        photoModel.type = GMPhotoModelMediaTypePhoto;
                    }else {
                        photoModel.type = self.configuration.lookGifPhoto ? GMPhotoModelMediaTypePhotoGif : GMPhotoModelMediaTypePhoto;
                    }
                }else if (asset.mediaSubtypes == PHAssetMediaSubtypePhotoLive){
                    if (iOS9Later) {
                        if (!self.configuration.singleSelected) {
                            photoModel.type = self.configuration.lookLivePhoto ? GMPhotoModelMediaTypeLivePhoto : GMPhotoModelMediaTypePhoto;
                        }else {
                            photoModel.type = GMPhotoModelMediaTypePhoto;
                        }
                    }else {
                        photoModel.type = GMPhotoModelMediaTypePhoto;
                    }
                }else {
                    photoModel.type = GMPhotoModelMediaTypePhoto;
                }
                //                if (!photoModel.isICloud) {
                [photoArray addObject:photoModel];
                //                }
            }else if (asset.mediaType == PHAssetMediaTypeVideo) {
                photoModel.subType = GMPhotoModelMediaSubTypeVideo;
                photoModel.type = GMPhotoModelMediaTypeVideo;
                //                if (!photoModel.isICloud) {
                [videoArray addObject:photoModel];
                //                }
                // 默认视频都是可选的
                [self changeModelVideoState:photoModel];
            }
            photoModel.currentAlbumIndex = albumModel.index;
            BOOL canAddPhoto = YES;
            if (self.configuration.filtrationICloudAsset) {
//                if (!photoModel.isICloud) {
//                    [allArray addObject:photoModel];
//                    [previewArray addObject:photoModel];
//                }else {
                    canAddPhoto = NO;
//                }
            }else {
                [allArray addObject:photoModel];
//                if (photoModel.isICloud) {
//                    if (self.configuration.downloadICloudAsset) {
//                        [previewArray addObject:photoModel];
//                    }
//                }else {
                    [previewArray addObject:photoModel];
//                }
            }
            if (self.configuration.showDateSectionHeader && canAddPhoto) {
                NSDate *photoDate = photoModel.creationDate;
                //        CLLocation *photoLocation = photoModel.location;
                if (!currentIndexDate) {
                    dateModel = [[GMPhotoDateModel alloc] init];
                    dateModel.date = photoDate;
                    sameDayArray = [NSMutableArray array];
                    [sameDayArray addObject:photoModel];
                    [dateArray addObject:dateModel];
                    photoModel.dateItem = sameDayArray.count - 1;
                    photoModel.dateSection = dateArray.count - 1;
                }else {
                    if ([self isSameDay:photoDate date2:currentIndexDate]) {
                        [sameDayArray addObject:photoModel];
                        photoModel.dateItem = sameDayArray.count - 1;
                        photoModel.dateSection = dateArray.count - 1;
                    }else {
                        dateModel.photoModelArray = sameDayArray;
                        sameDayArray = [NSMutableArray array];
                        dateModel = [[GMPhotoDateModel alloc] init];
                        dateModel.date = photoDate;
                        [sameDayArray addObject:photoModel];
                        [dateArray addObject:dateModel];
                        photoModel.dateItem = sameDayArray.count - 1;
                        photoModel.dateSection = dateArray.count - 1;
                    }
                }
                if (firstSelectModel && !already) {
                    firstSelectModel.dateSection = dateArray.count - 1;
                    firstSelectModel.dateItem = sameDayArray.count - 1;
                    already = YES;
                }
                if (index == albumModel.result.count - 1) {
                    dateModel.photoModelArray = sameDayArray;
                }
                if (!dateModel.location) {
                    if (photoModel.asset.location) {
                        dateModel.location = photoModel.asset.location;
                    }
                }
                currentIndexDate = photoDate;
            }else {
                photoModel.dateItem = allArray.count - 1;
                photoModel.dateSection = 0;
            }
            index++;
        }
    }
    if (!dateArray.count &&
        self.configuration.showDateSectionHeader &&
        (self.configuration.openCamera || self.cameraList.count > 0)) {
        dateModel = [[GMPhotoDateModel alloc] init];
        dateModel.date = [NSDate date];
        [dateArray addObject:dateModel];
    }
    NSInteger cameraIndex = self.configuration.openCamera ? 1 : 0;
    if (self.configuration.openCamera) {
        GMPhotoModel *model = [[GMPhotoModel alloc] init];
        model.type = GMPhotoModelMediaTypeCamera;
        if (photoArray.count == 0 && videoArray.count != 0) {
            model.thumbPhoto = [UIImage imageNamed:@"album_camera"];
            model.previewPhoto = [UIImage imageNamed:@"album_camera"];
        }else if (photoArray.count == 0) {
            model.thumbPhoto = [UIImage imageNamed:@"album_camera"];
            model.previewPhoto = [UIImage imageNamed:@"album_camera"];;
        }else {
            model.thumbPhoto = [UIImage imageNamed:@"album_camera"];
            model.previewPhoto = [UIImage imageNamed:@"album_camera"];
        }
        if (!self.configuration.reverseDate) {
            if (self.configuration.showDateSectionHeader) {
                model.dateSection = dateArray.count;
                GMPhotoDateModel *dateModel = dateArray.lastObject;
                model.dateItem = dateModel.photoModelArray.count;
                NSMutableArray *array = [NSMutableArray arrayWithArray:dateModel.photoModelArray];
                [array addObject:model];
                dateModel.photoModelArray = array;
            }else {
                model.dateSection = 0;
                model.dateItem = allArray.count;
            }
            [allArray addObject:model];
        }else {
            model.dateSection = 0;
            model.dateItem = 0;
            if (self.configuration.showDateSectionHeader) {
                GMPhotoDateModel *dateModel = dateArray.firstObject;
                NSMutableArray *array = [NSMutableArray arrayWithArray:dateModel.photoModelArray];
                [array insertObject:model atIndex:0];
                dateModel.photoModelArray = array;
            }else {
            }
            [allArray insertObject:model atIndex:0];
        }
    }
    if (self.cameraList.count > 0) {
        NSInteger index = 0;
        NSInteger photoIndex = 0;
        NSInteger videoIndex = 0;
        for (GMPhotoModel *model in self.cameraList) {
            if ([self.selectedCameraList containsObject:model]) {
                model.selected = YES;
                model.selectedIndex = [self.selectedList indexOfObject:model];
                model.selectIndexStr = [NSString stringWithFormat:@"%ld",model.selectedIndex + 1];
            }else {
                model.selected = NO;
                model.selectIndexStr = @"";
                model.selectedIndex = 0;
            }
            model.currentAlbumIndex = albumModel.index;
            if (self.configuration.reverseDate) {
                [allArray insertObject:model atIndex:cameraIndex + index];
                [previewArray insertObject:model atIndex:index];
                if (model.subType == GMPhotoModelMediaSubTypePhoto) {
                    [photoArray insertObject:model atIndex:photoIndex];
                    photoIndex++;
                }else {
                    [videoArray insertObject:model atIndex:videoIndex];
                    videoIndex++;
                }
            }else {
                NSInteger count = allArray.count;
                NSInteger atIndex = (count - cameraIndex) < 0 ? 0 : count - cameraIndex;
                [allArray insertObject:model atIndex:atIndex];
                [previewArray addObject:model];
                if (model.subType == GMPhotoModelMediaSubTypePhoto) {
                    [photoArray addObject:model];
                }else {
                    [videoArray addObject:model];
                }
            }
            if (self.configuration.showDateSectionHeader) {
                if (self.configuration.reverseDate) {
                    model.dateSection = 0;
                    GMPhotoDateModel *dateModel = dateArray.firstObject;
                    NSMutableArray *array = [NSMutableArray arrayWithArray:dateModel.photoModelArray];
                    [array insertObject:model atIndex:cameraIndex + index];
                    dateModel.photoModelArray = array;
                }else {
                    model.dateSection = (dateArray.count - 1) <= 0 ? 0 : dateArray.count - 1;
                    GMPhotoDateModel *dateModel = dateArray.lastObject;
                    
                    NSMutableArray *array = [NSMutableArray arrayWithArray:dateModel.photoModelArray];
                    NSInteger count = array.count;
                    NSInteger atIndex = (count - cameraIndex) < 0 ? 0 : count - cameraIndex;
                    [array insertObject:model atIndex:atIndex];
                    dateModel.photoModelArray = array;
                }
            }else {
                model.dateSection = 0;
            }
            index++;
        }
    }
    if (complete) {
        complete(allArray,previewArray,photoArray,videoArray,dateArray,firstSelectModel);
    }
}
- (void)addICloudModel:(GMPhotoModel *)model {
    if (![self.iCloudUploadArray containsObject:model]) {
        [self.iCloudUploadArray addObject:model];
    }
}
- (NSString *)maximumOfJudgment:(GMPhotoModel *)model {
    if ([self beforeSelectCountIsMaximum]) {
        // 已经达到最大选择数 [NSString stringWithFormat:@"最多只能选择%ld个",manager.maxNum]
        return [NSString stringWithFormat:@"最多只能选择%ld个",self.configuration.maxNum];
    }
    if (self.type == GMPhotoManagerSelectedTypePhotoAndVideo) {
        if ((model.type == GMPhotoModelMediaTypePhoto || model.type == GMPhotoModelMediaTypePhotoGif) || (model.type == GMPhotoModelMediaTypeCameraPhoto || model.type == GMPhotoModelMediaTypeLivePhoto)) {
            if (self.configuration.videoMaxNum > 0) {
                if (!self.configuration.selectTogether) { // 是否支持图片视频同时选择
                    if (self.selectedVideos.count > 0 ) {
                        // 已经选择了视频,不能再选图片
                        return @"图片不能和视频同时选择";
                    }
                }
            }
            if ([self beforeSelectPhotoCountIsMaximum]) {
                // 已经达到图片最大选择数
                return @"小主不要贪心哦，一次最多不超过9张图片哦～";
                //[NSString stringWithFormat:@"小主不要贪心哦，一次最多不超过%ld张图片哦～",self.configuration.photoMaxNum];
//                @"小主不要贪心哦，一次最多不超过%50个哦～";
            }
        }else if (model.type == GMPhotoModelMediaTypeVideo || model.type == GMPhotoModelMediaTypeCameraVideo) {
            if (self.configuration.photoMaxNum > 0) {
                if (!self.configuration.selectTogether) { // 是否支持图片视频同时选择
                    if (self.selectedPhotos.count > 0 ) {
                        // 已经选择了图片,不能再选视频
                        return @"视频不能和图片同时选择";
                    }
                }
            }
            if ([self beforeSelectVideoCountIsMaximum]) {
                // 已经达到视频最大选择数
                
                return @"一次上传视频最多不超过1个";//[NSString stringWithFormat:@"一次上传视频最多不超过10个",self.configuration.videoMaxNum];
            }
        }
    }else if (self.type == GMPhotoManagerSelectedTypePhoto) {
        if ([self beforeSelectPhotoCountIsMaximum]) {
            // 已经达到图片最大选择数
            return @"小主不要贪心哦，一次最多不超过%50个哦～";//[NSString stringWithFormat:@"最多只能选择%ld张图片",self.configuration.photoMaxNum];
        }
    }else if (self.type == GMPhotoManagerSelectedTypeVideo) {
        if ([self beforeSelectVideoCountIsMaximum]) {
            // 已经达到视频最大选择数
            return @"一次上传视频最多不超过10个";//[NSString stringWithFormat:@"最多只能选择%ld个视频",self.configuration.videoMaxNum];
        }
    }
    if (model.type == GMPhotoModelMediaTypeVideo) {
        if (model.asset.duration < 3) {
            return @"视频少于3秒,无法选择";
        }else if (model.asset.duration >= self.configuration.videoMaxDuration + 1) {
            return @"视频过大,无法选择";
        }
    }else if (model.type == GMPhotoModelMediaTypeCameraVideo) {
        if (model.videoDuration < 3) {
            return @"视频少于3秒,无法选择";
        }else if (model.videoDuration >= self.configuration.videoMaxDuration + 1) {
            return @"视频过大,无法选择";
        }
    }
    return nil;
}
#pragma mark - < 改变模型的视频状态 >
- (void)changeModelVideoState:(GMPhotoModel *)model {
    if (model.subType == GMPhotoModelMediaSubTypeVideo) {
        if (model.type == GMPhotoModelMediaTypeVideo) {
            if (model.asset.duration < 3) {
                model.videoState = GMPhotoModelVideoStateUndersize;
            }else if (model.asset.duration >= self.configuration.videoMaxDuration + 1) {
                model.videoState = GMPhotoModelVideoStateOversize;
            }
        }else if (model.type == GMPhotoModelMediaTypeCameraVideo) {
            if (model.videoDuration < 3) {
                model.videoState = GMPhotoModelVideoStateUndersize;
            }else if (model.videoDuration >= self.configuration.videoMaxDuration + 1) {
                model.videoState = GMPhotoModelVideoStateOversize;
            }
        }
    }
}
- (GMPhotoManagerVideoSelectedType)videoSelectedType {
    if (self.type == GMPhotoManagerSelectedTypePhotoAndVideo && self.configuration.videoMaxNum == 1 && !self.configuration.selectTogether) {
        return GMPhotoManagerVideoSelectedTypeSingle;
    }
    return GMPhotoManagerVideoSelectedTypeNormal;
}
- (BOOL)videoCanSelected {
    if (self.videoSelectedType == GMPhotoManagerVideoSelectedTypeSingle) {
        if (self.selectedPhotos.count) {
            return NO;
        }
    }
    return YES;
}
- (NSInteger)cameraCount {
    return self.cameraList.count;
}
- (GMPhotoModel *)firstCameraModel {
    return self.cameraList.firstObject;
}
#pragma mark - < 关于选择完成之前的一些方法 >
- (NSInteger)selectedCount {
    return self.selectedList.count;
}
- (NSInteger)selectedPhotoCount {
    return self.selectedPhotos.count;
}
- (NSInteger)selectedVideoCount {
    return self.selectedVideos.count;
}
- (NSArray *)selectedArray {
    return self.selectedList;
}
- (NSArray *)selectedPhotoArray {
    return self.selectedPhotos;
}
- (NSArray *)selectedVideoArray {
    return self.selectedVideos;
}
- (BOOL)original {
    return self.isOriginal;
}
- (void)setOriginal:(BOOL)original {
    self.isOriginal = original;
}

- (BOOL)beforeSelectCountIsMaximum {
    if (self.selectedList.count >= self.configuration.maxNum) {
        return YES;
    }
    return NO;
}
- (BOOL)beforeSelectPhotoCountIsMaximum {
    if (self.selectedPhotos.count >= (self.configuration.maxNum - self.configuration.videoMaxNum)) {
        return YES;
    }
    return NO;
}
- (BOOL)beforeSelectVideoCountIsMaximum {
    if (self.selectedVideos.count >= self.configuration.videoMaxNum) {
        return YES;
    }
    return NO;
}
- (void)beforeSelectedListdeletePhotoModel:(GMPhotoModel *)model {
    model.selected = NO;
    model.selectIndexStr = @"";
    if (model.subType == GMPhotoModelMediaSubTypePhoto) {
        [self.selectedPhotos removeObject:model];
        if (model.type == GMPhotoModelMediaTypeCameraPhoto) {
            // 为相机拍的照片时
            [self.selectedCameraPhotos removeObject:model];
            [self.selectedCameraList removeObject:model];
        }else {
            model.thumbPhoto = nil;
            model.previewPhoto = nil;
        }
    }else if (model.subType == GMPhotoModelMediaSubTypeVideo) {
        [self.selectedVideos removeObject:model];
        if (model.type == GMPhotoModelMediaTypeCameraVideo) {
            // 为相机录的视频时
            [self.selectedCameraVideos removeObject:model];
            [self.selectedCameraList removeObject:model];
        }else {
            model.thumbPhoto = nil;
            model.previewPhoto = nil;
        }
    }
    [self.selectedList removeObject:model];
}
- (void)beforeSelectedListAddPhotoModel:(GMPhotoModel *)model {
    if (model.subType == GMPhotoModelMediaSubTypePhoto) {
        [self.selectedPhotos addObject:model];
        if (model.type == GMPhotoModelMediaTypeCameraPhoto) {
            // 为相机拍的照片时
            [self.selectedCameraPhotos addObject:model];
            [self.selectedCameraList addObject:model];
        }
    }else if (model.subType == GMPhotoModelMediaSubTypeVideo) {
        [self.selectedVideos addObject:model];
        if (model.type == GMPhotoModelMediaTypeCameraVideo) {
            // 为相机录的视频时
            [self.selectedCameraVideos addObject:model];
            [self.selectedCameraList addObject:model];
        }
    }
    [self.selectedList addObject:model];
    model.selected = YES;
    model.selectIndexStr = [NSString stringWithFormat:@"%ld",[self.selectedList indexOfObject:model] + 1];
}
- (void)beforeSelectedListAddEditPhotoModel:(GMPhotoModel *)model {
    [self beforeSelectedListAddPhotoModel:model];
    // 默认视频都是可选的
    [self changeModelVideoState:model];
    
    if (model.subType == GMPhotoModelMediaSubTypePhoto) {
        if (model.type == GMPhotoModelMediaTypeCameraPhoto) {
            [self.cameraPhotos addObject:model];
            [self.cameraList addObject:model];
        }
    }else {
        if (model.type == GMPhotoModelMediaTypeCameraVideo) {
            [self.cameraVideos addObject:model];
            [self.cameraList addObject:model];
        }
    }
}
- (void)beforeListAddCameraTakePicturesModel:(GMPhotoModel *)model {
    // 默认视频都是可选的
    [self changeModelVideoState:model];
    
    model.dateCellIsVisible = YES;
    if (model.type == GMPhotoModelMediaTypeCameraPhoto) {
        [self.cameraPhotos addObject:model];
        if (![self beforeSelectPhotoCountIsMaximum]) {
            if (!self.configuration.selectTogether) {
                if (self.selectedList.count > 0) {
                    GMPhotoModel *phMd = self.selectedList.firstObject;
                    if (phMd.subType == GMPhotoModelMediaSubTypePhoto) {
                        [self.selectedCameraPhotos insertObject:model atIndex:0];
                        [self.selectedPhotos addObject:model];
                        [self.selectedList addObject:model];
                        [self.selectedCameraList addObject:model];
                        model.selected = YES;
                        model.selectIndexStr = [NSString stringWithFormat:@"%ld",[self.selectedList indexOfObject:model] + 1];
                    }
                }else {
                    [self.selectedCameraPhotos insertObject:model atIndex:0];
                    [self.selectedPhotos addObject:model];
                    [self.selectedList addObject:model];
                    [self.selectedCameraList addObject:model];
                    model.selected = YES;
                    model.selectIndexStr = [NSString stringWithFormat:@"%ld",[self.selectedList indexOfObject:model] + 1];
                }
            }else {
                [self.selectedCameraPhotos insertObject:model atIndex:0];
                [self.selectedPhotos addObject:model];
                [self.selectedList addObject:model];
                [self.selectedCameraList addObject:model];
                model.selected = YES;
                model.selectIndexStr = [NSString stringWithFormat:@"%ld",[self.selectedList indexOfObject:model] + 1];
            }
        }
    }else if (model.type == GMPhotoModelMediaTypeCameraVideo) {
        [self.cameraVideos addObject:model];
        // 当选中视频个数没有达到最大个数时就添加到选中数组中
        if (![self beforeSelectVideoCountIsMaximum] && model.videoDuration <= self.configuration.videoMaxDuration) {
            if (!self.configuration.selectTogether) {
                if (self.selectedList.count > 0) {
                    GMPhotoModel *phMd = self.selectedList.firstObject;
                    if (phMd.subType == GMPhotoModelMediaSubTypeVideo) {
                        [self.selectedCameraVideos insertObject:model atIndex:0];
                        [self.selectedVideos addObject:model];
                        [self.selectedList addObject:model];
                        [self.selectedCameraList addObject:model];
                        model.selected = YES;
                        model.selectIndexStr = [NSString stringWithFormat:@"%ld",[self.selectedList indexOfObject:model] + 1];
                    }
                }else {
                    if (!model.needHideSelectBtn) {
                        [self.selectedCameraVideos insertObject:model atIndex:0];
                        [self.selectedVideos addObject:model];
                        [self.selectedList addObject:model];
                        [self.selectedCameraList addObject:model];
                        model.selected = YES;
                        model.selectIndexStr = [NSString stringWithFormat:@"%ld",[self.selectedList indexOfObject:model] + 1];
                    }
                }
            }else {
                [self.selectedCameraVideos insertObject:model atIndex:0];
                [self.selectedVideos addObject:model];
                [self.selectedList addObject:model];
                [self.selectedCameraList addObject:model];
                model.selected = YES;
                model.selectIndexStr = [NSString stringWithFormat:@"%ld",[self.selectedList indexOfObject:model] + 1];
            }
        }
    }
    //    NSInteger cameraIndex = self.configuration.openCamera ? 1 : 0;
    if (self.configuration.reverseDate) {
        [self.cameraList insertObject:model atIndex:0];
    }else {
        [self.cameraList addObject:model];
    }
}
#pragma mark - < 关于选择完成之后的一些方法 >
- (BOOL)afterSelectCountIsMaximum {
    if (self.endSelectedList.count >= self.configuration.maxNum) {
        return YES;
    }
    return NO;
}

- (BOOL)afterSelectPhotoCountIsMaximum {
    if (self.endSelectedPhotos.count >= self.configuration.photoMaxNum) {
        return YES;
    }
    return NO;
}

- (BOOL)afterSelectVideoCountIsMaximum {
    if (self.endSelectedVideos.count >= self.configuration.videoMaxNum) {
        return YES;
    }
    return NO;
}
- (NSInteger)afterSelectedCount {
    return self.endSelectedList.count;
}
- (NSArray *)afterSelectedArray {
    return self.endSelectedList;
}
- (NSArray *)afterSelectedPhotoArray {
    return self.endSelectedPhotos;
}
- (NSArray *)afterSelectedVideoArray {
    return self.endSelectedVideos;
}
- (void)setAfterSelectedPhotoArray:(NSArray *)array {
    self.endSelectedPhotos = [NSMutableArray arrayWithArray:array];
}
- (void)setAfterSelectedVideoArray:(NSArray *)array {
    self.endSelectedVideos = [NSMutableArray arrayWithArray:array];
}
- (BOOL)afterOriginal {
    return self.endIsOriginal;
}
- (void)afterSelectedArraySwapPlacesWithFromModel:(GMPhotoModel *)fromModel fromIndex:(NSInteger)fromIndex toModel:(GMPhotoModel *)toModel toIndex:(NSInteger)toIndex {
    [self.endSelectedList removeObject:toModel];
    [self.endSelectedList insertObject:toModel atIndex:toIndex];
    [self.endSelectedList removeObject:fromModel];
    [self.endSelectedList insertObject:fromModel atIndex:fromIndex];
}
- (void)afterSelectedArrayReplaceModelAtModel:(GMPhotoModel *)atModel withModel:(GMPhotoModel *)model {
    atModel.selected = NO;
    model.selected = YES;
    
    // 默认视频都是可选的
    [self changeModelVideoState:model];
    
    [self.endSelectedList replaceObjectAtIndex:[self.endSelectedList indexOfObject:atModel] withObject:model];
    if (atModel.type == GMPhotoModelMediaTypeCameraPhoto) {
        [self.endSelectedCameraPhotos removeObject:atModel];
        [self.endSelectedCameraList removeObject:atModel];
        [self.endCameraList removeObject:atModel];
        [self.endCameraPhotos removeObject:atModel];
    }else if (atModel.type == GMPhotoModelMediaTypeCameraVideo) {
        [self.endSelectedCameraVideos removeObject:atModel];
        [self.endSelectedCameraList removeObject:atModel];
        [self.endCameraList removeObject:atModel];
        [self.endCameraVideos removeObject:atModel];
    }
}
- (void)afterSelectedListAddEditPhotoModel:(GMPhotoModel *)model {
    // 默认视频都是可选的
    [self changeModelVideoState:model];
    
    if (model.subType == GMPhotoModelMediaSubTypePhoto) {
        if (model.type == GMPhotoModelMediaTypeCameraPhoto) {
            [self.endCameraPhotos addObject:model];
            [self.endCameraList addObject:model];
            [self.endSelectedCameraList addObject:model];
            [self.endSelectedCameraPhotos addObject:model];
        }
    }else {
        if (model.type == GMPhotoModelMediaTypeCameraVideo) {
            [self.endCameraVideos addObject:model];
            [self.endCameraList addObject:model];
            [self.endSelectedCameraList addObject:model];
            [self.endSelectedCameraVideos addObject:model];
        }
    }
}
- (void)afterListAddCameraTakePicturesModel:(GMPhotoModel *)model {
    // 默认视频都是可选的
    [self changeModelVideoState:model];
    
    if (model.type == GMPhotoModelMediaTypeCameraPhoto) {
        [self.endCameraPhotos addObject:model];
        // 当选择图片个数没有达到最大个数时就添加到选中数组中
        if (![self afterSelectPhotoCountIsMaximum]) {
            if (!self.configuration.selectTogether) {
                if (self.endSelectedList.count > 0) {
                    GMPhotoModel *phMd = self.endSelectedList.firstObject;
                    if ((phMd.type == GMPhotoModelMediaTypePhoto || phMd.type == GMPhotoModelMediaTypeLivePhoto) || (phMd.type == GMPhotoModelMediaTypePhotoGif || phMd.type == GMPhotoModelMediaTypeCameraPhoto)) {
                        [self.endSelectedCameraPhotos insertObject:model atIndex:0];
                        [self.endSelectedPhotos addObject:model];
                        [self.endSelectedList addObject:model];
                        [self.endSelectedCameraList addObject:model];
                        model.selected = YES;
                        model.selectIndexStr = [NSString stringWithFormat:@"%ld",[self.endSelectedList indexOfObject:model] + 1];
                    }
                }else {
                    [self.endSelectedCameraPhotos insertObject:model atIndex:0];
                    [self.endSelectedPhotos addObject:model];
                    [self.endSelectedList addObject:model];
                    [self.endSelectedCameraList addObject:model];
                    model.selected = YES;
                    model.selectIndexStr = [NSString stringWithFormat:@"%ld",[self.endSelectedList indexOfObject:model] + 1];
                }
            }else {
                [self.endSelectedCameraPhotos insertObject:model atIndex:0];
                [self.endSelectedPhotos addObject:model];
                [self.endSelectedList addObject:model];
                [self.endSelectedCameraList addObject:model];
                model.selected = YES;
                model.selectIndexStr = [NSString stringWithFormat:@"%ld",[self.endSelectedList indexOfObject:model] + 1];
            }
        }
    }else if (model.type == GMPhotoModelMediaTypeCameraVideo) {
        [self.endCameraVideos addObject:model];
        // 当选中视频个数没有达到最大个数时就添加到选中数组中
        if (![self afterSelectVideoCountIsMaximum] && model.videoDuration <= self.configuration.videoMaxDuration) {
            if (!self.configuration.selectTogether) {
                if (self.endSelectedList.count > 0) {
                    GMPhotoModel *phMd = self.endSelectedList.firstObject;
                    if (phMd.type == GMPhotoModelMediaTypeVideo || phMd.type == GMPhotoModelMediaTypeCameraVideo) {
                        [self.endSelectedCameraVideos insertObject:model atIndex:0];
                        [self.endSelectedVideos addObject:model];
                        [self.endSelectedList addObject:model];
                        [self.endSelectedCameraList addObject:model];
                        model.selected = YES;
                        model.selectIndexStr = [NSString stringWithFormat:@"%ld",[self.endSelectedList indexOfObject:model] + 1];
                    }
                }else {
                    [self.endSelectedCameraVideos insertObject:model atIndex:0];
                    [self.endSelectedVideos addObject:model];
                    [self.endSelectedList addObject:model];
                    [self.endSelectedCameraList addObject:model];
                    model.selected = YES;
                    model.selectIndexStr = [NSString stringWithFormat:@"%ld",[self.endSelectedList indexOfObject:model] + 1];
                }
            }else {
                [self.endSelectedCameraVideos insertObject:model atIndex:0];
                [self.endSelectedVideos addObject:model];
                [self.endSelectedList addObject:model];
                [self.endSelectedCameraList addObject:model];
                model.selected = YES;
                model.selectIndexStr = [NSString stringWithFormat:@"%ld",[self.endSelectedList indexOfObject:model] + 1];
            }
        }
    }
    [self.endCameraList addObject:model];
    self.firstHasCameraAsset = YES;
}
- (void)afterSelectedListdeletePhotoModel:(GMPhotoModel *)model {
    if (model.subType == GMPhotoModelMediaSubTypePhoto) {
        if (model.type == GMPhotoModelMediaTypeCameraPhoto) {
            if (self.configuration.deleteTemporaryPhoto) {
                [self.endCameraPhotos removeObject:model];
                [self.endCameraList removeObject:model];
            }
            [self.endSelectedCameraPhotos removeObject:model];
            [self.endSelectedCameraList removeObject:model];
        }
        [self.endSelectedPhotos removeObject:model];
    }else if (model.subType == GMPhotoModelMediaSubTypeVideo) {
        if (model.type == GMPhotoModelMediaTypeCameraVideo) {
            if (self.configuration.deleteTemporaryPhoto) {
                [self.endCameraVideos removeObject:model];
                [self.endCameraList removeObject:model];
            }
            [self.endSelectedCameraVideos removeObject:model];
            [self.endSelectedCameraList removeObject:model];
        }
        [self.endSelectedVideos removeObject:model];
    }
    [self.endSelectedList removeObject:model];
    
    int i = 0;
    for (GMPhotoModel *model in self.selectedList) {
        model.selectIndexStr = [NSString stringWithFormat:@"%d",i + 1];
        i++;
    }
}
- (void)afterSelectedListAddPhotoModel:(GMPhotoModel *)model {
    // 默认视频都是可选的
    [self changeModelVideoState:model];
    
    if (model.subType == GMPhotoModelMediaSubTypePhoto) {
        if (model.type == GMPhotoModelMediaTypeCameraPhoto) {
            [self.endCameraPhotos addObject:model];
            [self.endCameraList addObject:model];
            [self.endSelectedCameraList addObject:model];
            [self.endSelectedCameraPhotos addObject:model];
        }
        [self.endSelectedPhotos addObject:model];
    }else {
        if (model.type == GMPhotoModelMediaTypeCameraVideo) {
            [self.endCameraVideos addObject:model];
            [self.endCameraList addObject:model];
            [self.endSelectedCameraList addObject:model];
            [self.endSelectedCameraVideos addObject:model];
        }
        [self.endSelectedVideos addObject:model];
    }
    [self.endSelectedList addObject:model];
}
#pragma mark - < others >
- (void)selectedListTransformBefore {
    if (self.type == GMPhotoManagerSelectedTypePhoto) {
        self.configuration.maxNum = self.configuration.photoMaxNum;
        if (self.endCameraVideos.count > 0) {
            [self.endCameraList removeObjectsInArray:self.endCameraVideos];
            [self.endCameraVideos removeAllObjects];
        }
    }else if (self.type == GMPhotoManagerSelectedTypeVideo) {
        self.configuration.maxNum = self.configuration.videoMaxNum;
        if (self.endCameraPhotos.count > 0) {
            [self.endCameraList removeObjectsInArray:self.endCameraPhotos];
            [self.endCameraPhotos removeAllObjects];
        }
    }else {
        if (self.configuration.videoMaxNum + self.configuration.photoMaxNum != self.configuration.maxNum) {
            self.configuration.maxNum = self.configuration.videoMaxNum + self.configuration.photoMaxNum;
        }
    }
    // 上次选择的所有记录
    self.selectedList = [NSMutableArray arrayWithArray:self.endSelectedList];
    self.selectedPhotos = [NSMutableArray arrayWithArray:self.endSelectedPhotos];
    self.selectedVideos = [NSMutableArray arrayWithArray:self.endSelectedVideos];
    self.cameraList = [NSMutableArray arrayWithArray:self.endCameraList];
    self.cameraPhotos = [NSMutableArray arrayWithArray:self.endCameraPhotos];
    self.cameraVideos = [NSMutableArray arrayWithArray:self.endCameraVideos];
    self.selectedCameraList = [NSMutableArray arrayWithArray:self.endSelectedCameraList];
    self.selectedCameraPhotos = [NSMutableArray arrayWithArray:self.endSelectedCameraPhotos];
    self.selectedCameraVideos = [NSMutableArray arrayWithArray:self.endSelectedCameraVideos];
    self.isOriginal = self.endIsOriginal;
    self.photosTotalBtyes = self.endPhotosTotalBtyes;
}
- (void)selectedListTransformAfter {
    // 如果通过相机拍的数组为空 则清空所有关于相机的数组
    if (self.configuration.deleteTemporaryPhoto) {
        if (self.selectedCameraList.count == 0) {
            [self.cameraList removeAllObjects];
            [self.cameraVideos removeAllObjects];
            [self.cameraPhotos removeAllObjects];
        }
    }
    if (!self.configuration.singleSelected) {
        // 记录这次操作的数据
        self.endSelectedList = [NSMutableArray arrayWithArray:self.selectedList];
        self.endSelectedPhotos = [NSMutableArray arrayWithArray:self.selectedPhotos];
        self.endSelectedVideos = [NSMutableArray arrayWithArray:self.selectedVideos];
        self.endCameraList = [NSMutableArray arrayWithArray:self.cameraList];
        self.endCameraPhotos = [NSMutableArray arrayWithArray:self.cameraPhotos];
        self.endCameraVideos = [NSMutableArray arrayWithArray:self.cameraVideos];
        self.endSelectedCameraList = [NSMutableArray arrayWithArray:self.selectedCameraList];
        self.endSelectedCameraPhotos = [NSMutableArray arrayWithArray:self.selectedCameraPhotos];
        self.endSelectedCameraVideos = [NSMutableArray arrayWithArray:self.selectedCameraVideos];
        self.endIsOriginal = self.isOriginal;
        self.endPhotosTotalBtyes = self.photosTotalBtyes;
    }
}
- (void)cancelBeforeSelectedList {
    [self.selectedList removeAllObjects];
    [self.selectedPhotos removeAllObjects];
    [self.selectedVideos removeAllObjects];
    self.isOriginal = NO;
    self.photosTotalBtyes = nil;
    [self.selectedCameraList removeAllObjects];
    [self.selectedCameraVideos removeAllObjects];
    [self.selectedCameraPhotos removeAllObjects];
    [self.cameraPhotos removeAllObjects];
    [self.cameraList removeAllObjects];
    [self.cameraVideos removeAllObjects];
}
- (void)clearSelectedList {
    [self.endSelectedList removeAllObjects];
    [self.endCameraPhotos removeAllObjects];
    [self.endSelectedCameraPhotos removeAllObjects];
    [self.endCameraList removeAllObjects];
    [self.endSelectedCameraList removeAllObjects];
    [self.endSelectedPhotos removeAllObjects];
    [self.endCameraVideos removeAllObjects];
    [self.endSelectedCameraVideos removeAllObjects];
    [self.endCameraList removeAllObjects];
    [self.endSelectedCameraList removeAllObjects];
    [self.endSelectedVideos removeAllObjects];
    [self.endSelectedPhotos removeAllObjects];
    [self.endSelectedVideos removeAllObjects];
    self.endIsOriginal = NO;
    self.endPhotosTotalBtyes = nil;
    
    [self.selectedList removeAllObjects];
    [self.cameraPhotos removeAllObjects];
    [self.selectedCameraPhotos removeAllObjects];
    [self.cameraList removeAllObjects];
    [self.selectedCameraList removeAllObjects];
    [self.selectedPhotos removeAllObjects];
    [self.cameraVideos removeAllObjects];
    [self.selectedCameraVideos removeAllObjects];
    [self.cameraList removeAllObjects];
    [self.selectedCameraList removeAllObjects];
    [self.selectedVideos removeAllObjects];
    [self.selectedPhotos removeAllObjects];
    [self.selectedVideos removeAllObjects];
    self.isOriginal = NO;
    self.photosTotalBtyes = nil;
    
    [self.albums removeAllObjects];
    [self.iCloudUploadArray removeAllObjects];
}

#pragma mark - < PHPhotoLibraryChangeObserver >
- (void)photoLibraryDidChange:(PHChange *)changeInstance {
    /*
     NSMutableArray *array = [NSMutableArray arrayWithArray:self.albums];
     for (GMAlbumModel *albumModel in array) {
     PHFetchResultChangeDetails *collectionChanges = [changeInstance changeDetailsForFetchResult:albumModel.result];
     if ([collectionChanges hasIncrementalChanges]) {
     if (self.configuration.saveSystemAblum) {
     //                if (!self.cameraList.count) {
     //                    self.albums = nil;
     //                }
     }
     return;
     }
     }
     */
}
- (void)dealloc {
    [[PHPhotoLibrary sharedPhotoLibrary] unregisterChangeObserver:self];
//    NSSLog(@"dealloc");
}

- (void)changeAfterCameraArray:(NSArray *)array {
    self.endCameraList = array.mutableCopy;
}
- (void)changeAfterCameraPhotoArray:(NSArray *)array {
    self.endCameraPhotos = array.mutableCopy;
}
- (void)changeAfterCameraVideoArray:(NSArray *)array {
    self.endCameraVideos = array.mutableCopy;
}
- (void)changeAfterSelectedCameraArray:(NSArray *)array {
    self.endSelectedCameraList = array.mutableCopy;
}
- (void)changeAfterSelectedCameraPhotoArray:(NSArray *)array {
    self.endSelectedCameraPhotos = array.mutableCopy;
}
- (void)changeAfterSelectedCameraVideoArray:(NSArray *)array {
    self.endSelectedCameraVideos = array.mutableCopy;
}
- (void)changeAfterSelectedArray:(NSArray *)array {
    self.endSelectedList = array.mutableCopy;
}
- (void)changeAfterSelectedPhotoArray:(NSArray *)array {
    self.endSelectedPhotos = array.mutableCopy;
}
- (void)changeAfterSelectedVideoArray:(NSArray *)array {
    self.endSelectedVideos = array.mutableCopy;
}
- (void)changeICloudUploadArray:(NSArray *)array {
    self.iCloudUploadArray = array.mutableCopy;
}
- (NSArray *)afterCameraArray {
    return self.endCameraList;
}
- (NSArray *)afterCameraPhotoArray {
    return self.endCameraPhotos;
}
- (NSArray *)afterCameraVideoArray {
    return self.endCameraVideos;
}
- (NSArray *)afterSelectedCameraArray {
    return self.endSelectedCameraList;
}
- (NSArray *)afterSelectedCameraPhotoArray {
    return self.endSelectedCameraPhotos;
}
- (NSArray *)afterSelectedCameraVideoArray {
    return self.endSelectedCameraVideos;
}
- (NSArray *)afterICloudUploadArray {
    return self.iCloudUploadArray;
}
- (NSString *)version {
    return @"2.2.1";
}

#pragma mark - < 保存草稿功能 >
- (void)saveSelectModelArraySuccess:(void (^)(void))success failed:(void (^)(void))failed {
    if (!self.afterSelectedArray.count) {
        if (failed) failed();
        return;
    }
    dispatch_async(dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0), ^{
        NSMutableArray *gifModel = [NSMutableArray array];
        for (GMPhotoModel *model in self.afterSelectedArray) {
            if (model.type == GMPhotoModelMediaTypePhotoGif && !model.gifImageData) {
                [gifModel addObject:model];
            }
        }
//        if (gifModel.count) {
//            GMWeakSelf
//            [[[GMDatePhotoToolManager alloc] init] gifModelAssignmentData:gifModel success:^{
//                BOOL su = [weakSelf saveSelectModelArray];
//                if (!su) {
//                    dispatch_async(dispatch_get_main_queue(), ^{
//                        if (failed) {
//                            failed();
//                        }
//                        if (showLog) NSSLog(@"保存草稿失败啦!");
//                    });
//                }else {
//                    dispatch_async(dispatch_get_main_queue(), ^{
//                        if (success) {
//                            success();
//                        }
//                    });
//                }
//            } failed:^{
//                dispatch_async(dispatch_get_main_queue(), ^{
//                    if (failed) {
//                        failed();
//                    }
//                    if (showLog) NSSLog(@"保存草稿失败啦!");
//                });
//            }];
//        }else {
//            BOOL su = [self saveSelectModelArray];
//            if (!su) {
//                dispatch_async(dispatch_get_main_queue(), ^{
//                    if (failed) {
//                        failed();
//                    }
//                    if (showLog) NSSLog(@"保存草稿失败啦!");
//                });
//            }else {
//                dispatch_async(dispatch_get_main_queue(), ^{
//                    if (success) {
//                        success();
//                    }
//                });
//            }
//        }
    });
}

- (BOOL)deleteLocalSelectModelArray {
    return [self deleteSelectModelArray];
}

- (void)getSelectedModelArrayComplete:(void (^)(NSArray<GMPhotoModel *> *modelArray))complete  {
    dispatch_async(dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0), ^{
        NSArray *modelArray = [self getSelectedModelArray];
        
        dispatch_async(dispatch_get_main_queue(), ^{
            if (complete) {
                complete(modelArray);
            }
        });
    });
}

- (BOOL)saveSelectModelArray {
    NSMutableData *data = [[NSMutableData alloc] init];
    //创建归档辅助类
    NSKeyedArchiver *archiver = [[NSKeyedArchiver alloc] initForWritingWithMutableData:data];
    //编码
    [archiver encodeObject:self.afterSelectedArray forKey:GMEncodeKey];
    //结束编码
    [archiver finishEncoding];
    //写入到沙盒
    NSArray *array =  NSSearchPathForDirectoriesInDomains(NSDocumentDirectory, NSUserDomainMask, YES);
    NSString *toFileName = [array.firstObject stringByAppendingPathComponent:self.configuration.localFileName];
    
    if([data writeToFile:toFileName atomically:YES]){
//        if (showLog) NSSLog(@"归档成功");
        return YES;
    }
    return NO;
}

- (NSArray<GMPhotoModel *> *)getSelectedModelArray {
    NSArray *array =  NSSearchPathForDirectoriesInDomains(NSDocumentDirectory, NSUserDomainMask, YES);
    NSString *toFileName = [array.firstObject stringByAppendingPathComponent:self.configuration.localFileName];
    //解档
    NSData *undata = [[NSData alloc] initWithContentsOfFile:toFileName];
    //解档辅助类
    NSKeyedUnarchiver *unarchiver = [[NSKeyedUnarchiver alloc] initForReadingWithData:undata];
    //解码并解档出model
    NSArray *tempArray = [unarchiver decodeObjectForKey:GMEncodeKey];
    //关闭解档
    [unarchiver finishDecoding];
    return tempArray.copy;
}

- (BOOL)deleteSelectModelArray {
    NSArray *array =  NSSearchPathForDirectoriesInDomains(NSDocumentDirectory, NSUserDomainMask, YES);
    NSString *toFileName = [array.firstObject stringByAppendingPathComponent:self.configuration.localFileName];
    NSError *error;
    [[NSFileManager defaultManager] removeItemAtPath:toFileName error:&error];
    if (error) {
//        if (showLog) NSSLog(@"删除失败");
        return NO;
    }
    return YES;
}

@end

