//
//  GMAlbumModel.h
//  Gengmei
//
//  Created by Q14 on 2018/9/28.
//  Copyright © 2018年 更美互动信息科技有限公司. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <Photos/Photos.h>
#import "GMPhotoManager.h"

typedef NS_ENUM(NSUInteger, GMPhotoModelMediaType) {
    GMPhotoModelMediaTypePhoto          = 0,    // 照片
    GMPhotoModelMediaTypeLivePhoto      = 1,    // LivePhoto
    GMPhotoModelMediaTypePhotoGif       = 2,    // gif图
    GMPhotoModelMediaTypeVideo          = 3,    // 视频
    GMPhotoModelMediaTypeAudio          = 4,    // 预留
    GMPhotoModelMediaTypeCameraPhoto    = 5,    // 通过相机拍的照片
    GMPhotoModelMediaTypeCameraVideo    = 6,    // 通过相机录制的视频
    GMPhotoModelMediaTypeCamera         = 7     // 跳转相机
};
typedef NS_ENUM(NSUInteger, GMPhotoModelMediaSubType) {
    GMPhotoModelMediaSubTypePhoto = 0,  //!< 照片
    GMPhotoModelMediaSubTypeVideo       //!< 视频
};

typedef NS_ENUM(NSUInteger, GMPhotoModelVideoState) {
    GMPhotoModelVideoStateNormal = 0,   //!< 普通状态
    GMPhotoModelVideoStateUndersize,    //!< 视频时长小于3秒
    GMPhotoModelVideoStateOversize      //!< 视频时长超出限制
};

@interface GMPhotoModel : GMObject
/**
 文件在手机里的原路径(照片 或 视频)
 
 - 如果是通过相机拍摄的并且没有保存到相册(临时的) 视频有值, 照片没有值
 */
@property (nonatomic, strong) NSURL<Ignore> *fileURL;
/**
 位置信息 CLLocation 对象
 
 - 通过相机拍摄的时候有定位权限的话就有值
 */
@property (nonatomic, strong) CLLocation<Ignore> *location;

/**
 创建日期
 
 - 如果是通过相机拍摄的并且没有保存到相册(临时的) 为当前时间([NSDate date])
 */
@property (nonatomic, strong) NSDate<Ignore> *creationDate;
/**
 修改日期
 
 - 如果是通过相机拍摄的并且没有保存到相册(临时的) 为当前时间([NSDate date])
 */
@property (nonatomic, strong) NSDate<Ignore> *modificationDate;
/**
 位置信息 NSData 对象
 
 - 如果是通过相机拍摄的并且没有保存到相册(临时的) 没有值
 */
@property (nonatomic, strong) NSData<Ignore> *locationData;
@property (nonatomic, assign) long long timeStamp;
/**  照片PHAsset对象  */
@property (nonatomic, strong) PHAsset<Ignore> *asset;
/**  视频AVAsset对象  */
@property (nonatomic, strong) AVAsset<Ignore> *avAsset;
/**  PHAsset对象唯一标示  */
@property (nonatomic, copy) NSString<Ignore> *localIdentifier;

/**  照片类型  */
@property (nonatomic, assign) GMPhotoModelMediaType type;
/**  照片子类型  */
@property (nonatomic, assign) GMPhotoModelMediaSubType subType;
/**  临时的列表小图  */
@property (nonatomic, strong) UIImage<Ignore> *thumbPhoto;
/**  临时的预览大图  */
@property (nonatomic, strong) UIImage<Ignore> *previewPhoto;
/**  当前照片所在相册的名称 */
@property (nonatomic, copy) NSString<Ignore> *albumName;
/**  视频时长 */
@property (nonatomic, copy) NSString<Ignore> *videoTime;
/**  相机拍摄之后的视频秒数 */
@property (nonatomic, assign) NSTimeInterval videoDuration;
/**  选择的下标 */
@property (nonatomic, assign) NSInteger selectedIndex;
/**  模型对应的Section */
@property (nonatomic, assign) NSInteger dateSection;
/**  模型对应的item */
@property (nonatomic, assign) NSInteger dateItem;
/**  cell是否显示过 */
@property (nonatomic, assign) BOOL dateCellIsVisible;
/**  是否选中 */
@property (nonatomic, assign) BOOL selected;
/**  模型所对应的选中下标 */
@property (nonatomic, copy) NSString<Ignore> *selectIndexStr;
/**  照片原始宽高 */
@property (nonatomic, assign) CGSize imageSize;
/**  预览界面按比例缩小之后的宽高 */
@property (nonatomic, assign) CGSize endImageSize;
/**  预览界面按比例缩小之后的宽高 */
@property (nonatomic,assign) CGSize endDateImageSize;
/**  3dTouch按比例缩小之后的宽高 */
@property (nonatomic, assign) CGSize previewViewSize;

/**  拍照之后的唯一标示 */
@property (nonatomic, copy) NSString<Ignore> *cameraIdentifier;
/**  通过相机摄像的视频URL */
@property (nonatomic, strong) NSURL<Ignore> *videoURL;
/**  通过相机摄像的视频URL */
@property (nonatomic, copy) NSString<Ignore> *video;

/**  网络图片的地址 */
@property (nonatomic, copy) NSURL<Ignore> *networkPhotoUrl;
/**  当前图片所在相册的下标 */
@property (nonatomic, assign) NSInteger currentAlbumIndex;
/**  网络图片已下载的大小 */
@property (nonatomic, assign) NSInteger receivedSize;
/**  网络图片总的大小 */
@property (nonatomic, assign) NSInteger expectedSize;
/**  网络图片是否下载完成 */
@property (assign, nonatomic) BOOL downloadComplete;
/**  网络图片是否下载错误 */
@property (nonatomic, assign) BOOL downloadError;
/**  临时图片 */
@property (nonatomic, strong) UIImage<Ignore> *tempImage;
/**  行数 */
@property (nonatomic, assign) NSInteger rowCount;
/**  照片列表请求的资源的大小 */
@property (nonatomic, assign) CGSize requestSize;
/**
 小图照片清晰度 越大越清晰、越消耗性能。太大可能会引起界面卡顿
 默认设置：[UIScreen mainScreen].bounds.size.width
 320    ->  0.8
 375    ->  1.4
 other  ->  1.7
 */
@property (nonatomic, assign) CGFloat clarityScale;
/**  如果当前为视频资源时是禁止选择  */
@property (nonatomic, assign) BOOL videoUnableSelect;
/**  是否隐藏选择按钮  */
@property (nonatomic, assign) BOOL needHideSelectBtn;

/**  如果当前为视频资源时的视频状态  */
@property (nonatomic, assign) GMPhotoModelVideoState videoState;

@property (nonatomic, strong) NSData<Ignore> *gifImageData;
@property (nonatomic, copy) NSString<Ignore> *fullPathToFile;;
@property (nonatomic, strong) GMPhotoManager<Ignore> *photoManager;
/**  预览界面底部cell按比例缩小之后的宽高 */
@property (assign, nonatomic) CGSize dateBottomImageSize;

@property (nonatomic, copy) NSString *image; // 发布上传成功的URL
@property (nonatomic, copy) NSString *imageName; // 存草稿上传成功的URL
@property (nonatomic, assign) BOOL isUploadSuccess;

/**  通过image初始化 */
+ (instancetype)photoModelWithImage:(UIImage *)image;
/**  通过视频地址和视频时长初始化 */
+ (instancetype)photoModelWithVideoURL:(NSURL *)videoURL videoTime:(NSTimeInterval)videoTime;
/**  通过PHAsset对象初始化 */
+ (instancetype)photoModelWithPHAsset:(PHAsset *)asset;
/**  通过网络图片URL对象初始化 */
+ (instancetype)photoModelWithImageURL:(NSURL *)imageURL;
/**  通过本地视频地址URL对象初始化 */
+ (instancetype)photoModelWithVideoURL:(NSURL *)videoURL;
@end


@class CLGeocoder;
@interface GMPhotoDateModel : NSObject
/**  位置信息 - 如果当前天数内包含带有位置信息的资源则有值 */
@property (nonatomic, strong) CLLocation *location;
/**  日期信息 */
@property (nonatomic, strong) NSDate *date;
/**  日期信息字符串 */
@property (nonatomic, copy) NSString *dateString;
/**  位置信息字符串 */
@property (nonatomic, copy) NSString *locationString;;
/**  同一天的资源数组 */
@property (nonatomic, copy) NSArray *photoModelArray;
/**  位置信息子标题 */
@property (nonatomic, copy) NSString *locationSubTitle;
/**  位置信息标题 */
@property (nonatomic, copy) NSString *locationTitle;

@property (nonatomic, strong) NSMutableArray *locationList;
@property (nonatomic, assign) BOOL hasLocationTitles;


@end
