//
//  GMTopicTools.m
//  Gengmei
//
//  Created by Q14 on 2018/10/14.
//  Copyright © 2018年 更美互动信息科技有限公司. All rights reserved.
//

#import "GMTopicTools.h"
#import "GMPhotoModel.h"
#import "NSDate+DateFormat.h"

@implementation GMTopicTools

//+ (NSArray *)getTopicArrayWithcurrentDiayObj:(ALCreateDiaryObject*)currentObj imageArray:(NSArray<GMPhotoModel *>  *)imageArray videoList:(NSArray<GMPhotoModel *>  *)videoArray needTimestamp:(BOOL) needTimestamp {
//    NSMutableArray *images = [NSMutableArray array];//[NSMutableArray arrayWithArray:imageArray];
//    NSMutableArray *videos = [NSMutableArray array];//[NSMutableArray arrayWithArray:videoArray];
//
//    if (currentObj!= nil) {
//        [images addObjectsFromArray:currentObj.images];
//        if (currentObj.videoFileURL || [currentObj.videoUrl isNonEmpty]) {
//            if (currentObj.videoFileURL) {
//                GMPhotoModel *videoModel = [GMPhotoModel photoModelWithVideoURL:currentObj.videoFileURL videoTime:1];
//                [videos addObject:videoModel];
//            } else {
//                GMPhotoModel *videoModel = [GMPhotoModel photoModelWithVideoURL:[NSURL URLWithString:currentObj.videoUrl] videoTime:1];
//                [videos addObject:videoModel];
//            }
//        }
//    }
//    [images addObjectsFromArray:imageArray];
//    [videos addObjectsFromArray:videoArray];
//    
//    NSInteger topicCount =0;
//    if (images.count < 9) {
//        topicCount = 1;
//    } else {
//       topicCount = ((images.count%9) == 0) ? (images.count/9) : (images.count/9 + 1);
//    }
//    
//    NSMutableArray *topicArray = [NSMutableArray array];
//    for (int i = 0; i < topicCount; i++) {
//        if (images.count == 0) {
//            break;
//        }
//        ALCreateDiaryObject *obj = [[ALCreateDiaryObject alloc] init];
//       
//        NSMutableArray *muImages = [NSMutableArray array];
//        for (int j= i*9; j< (i+1) * 9; j++) {
//            if ((images.count-1) < j) {
//                break ;
//            }
//            if ((j == i*9) && needTimestamp) {
//                GMPhotoModel *model = images[j];
//                obj.operationDate = model.timeStamp;
//            }
//            [muImages addObject:images[j]];
//        }
//        obj.images = (NSMutableArray<GMPhotoModel> *)muImages;
//        obj.video = @"";
//        if ((i == 0) && currentObj) {
//            currentObj.images = obj.images;
//        } else {
//            [topicArray addObject:obj];
//        }
//    }
//    if (!videoArray.count) {
//        return topicArray;
//    }
//    for (int i = 0; i< videos.count; i++) {
//        if (i < topicArray.count) {
//            ALCreateDiaryObject *obj  = topicArray[i];
//            GMPhotoModel *video = videos[i];
//            obj.videoFileURL = video.fileURL;
//            obj.thumbPhoto = video.thumbPhoto;
//            obj.avAsset = video.asset;
//        } else {
//            ALCreateDiaryObject *obj = [[ALCreateDiaryObject alloc] init];
//            GMPhotoModel *video = videos[i];
//            if (i == 0 && video.fileURL && currentObj) {
//                currentObj.videoFileURL = video.fileURL;
//                currentObj.thumbPhoto = video.thumbPhoto;
//            } else {
//                obj.videoFileURL = video.fileURL;
//                obj.thumbPhoto = video.thumbPhoto;
//                if (needTimestamp) {
//                    obj.operationDate = video.timeStamp;
//                }
//                [topicArray addObject:obj];
//            }
//        }
//    }
//    return topicArray;
//}

+ (NSArray *)sortByDatePhotoArray:(NSArray<GMPhotoModel *>  *)dataArray {
    
    NSMutableArray *timeArr = [[NSMutableArray alloc]init];
    // 时间戳-对象字典，将对象和其对应的时间戳字符串存入字典（哈希表）
    NSMutableDictionary *dateKeyArr = [[NSMutableDictionary alloc]init];
    
    // 2.时间戳取出，并格式化处理
    for(GMPhotoModel *model in dataArray) {
        [timeArr addObject:model.creationDate];
        // 时间戳转成时间戳字符串作为key,制作哈希表
        NSNumber *dataNum = [NSNumber numberWithLongLong:model.timeStamp];
        NSString *datekey = [dataNum stringValue];
        [dateKeyArr setObject:model forKey:datekey];
    }
    
    // 3.将时间NSDate数组排序
    NSArray *orderedDateArray = [timeArr sortedArrayUsingComparator:^NSComparisonResult(NSDate *date1, NSDate *date2) {
        // 升序排序，最近的时间靠后
        return [date1 compare:date2];
    }];
    
    // 临时数组，保存排序后的对象数组
    NSMutableArray *sortedAccounts = [[NSMutableArray alloc]init];
    NSDate *datekey = [[NSDate alloc] init];
    for (int i = 0; i<orderedDateArray.count; i++) {
        datekey = orderedDateArray[i];
        // 日期对象转换成时间戳字符串key
        NSString *datekeys = [NSString stringWithFormat:@"%lld", (long long)[datekey timeIntervalSince1970]];
        // 根据时间戳字符串key取对应的对象（哈希表）
        [sortedAccounts addObject:[dateKeyArr objectForKey:datekeys]];
    }
    
    return sortedAccounts;
}

//+ (NSArray *)spiltArrayUseDate:(NSArray<GMPhotoModel *>  *)dataArray {
//    //按照时间排序
//    NSMutableArray *sortArray = (NSMutableArray *)[self sortByDatePhotoArray:dataArray];
//    NSMutableArray *sortEndArray = [NSMutableArray array];
//    NSMutableDictionary *dateKeyDic = [[NSMutableDictionary alloc] init];
//    for (GMPhotoModel *model in sortArray) {
//        NSString *key = [model.creationDate dateFormatToString];
//        NSMutableArray *dateArray = dateKeyDic[key];
//        if (dateArray.count > 0) {
//            [dateArray addObject:model];
//        } else {
//            dateArray = [NSMutableArray array];
//            [dateArray addObject:model];
//            [sortEndArray addObject:dateArray];
//            [dateKeyDic setObject:dateArray  forKey:key];
//        }
//    }
//    NSMutableArray *tempArray = [NSMutableArray array];
//    for (NSMutableArray *dateArray in sortEndArray) {
//        NSMutableArray *imageArray = [NSMutableArray array];
//        NSMutableArray *videoArray = [NSMutableArray array];
//        for (GMPhotoModel *model in dateArray) {
//            if ((model.type == GMPhotoModelMediaTypePhoto || model.type == GMPhotoModelMediaTypePhotoGif) || (model.type == GMPhotoModelMediaTypeLivePhoto || model.type == GMPhotoModelMediaTypeCameraPhoto)) {
//                [imageArray addObject:model];
//            } else {
//                [videoArray addObject:model];
//            }
//        }
//        [tempArray addObjectsFromArray:[self getTopicArrayWithcurrentDiayObj:nil imageArray:imageArray videoList:videoArray needTimestamp:YES]];
//    }
//    return tempArray;
//}
//判断是否选择了多天的日记或者视频
+ (BOOL)isSameDayPhotoOrVideo:(NSArray<GMPhotoModel *>  *)dataArray {
    NSMutableDictionary *dateKeyDic = [[NSMutableDictionary alloc] init];
    for (GMPhotoModel *model in dataArray) {
        NSString *key = [model.creationDate dateFormatToString];
        NSMutableArray *dateArray = dateKeyDic[key];
        if (!dateArray) {
            dateArray = [NSMutableArray array];
            [dateArray addObject:model];
            [dateKeyDic setObject:dateArray  forKey:key];
        }
    }
    if (dateKeyDic.allValues.count >1) {
        return YES;
    } else {
        return NO;
    }
}
@end
