//
//  UIView+GMExtension.m
//  Gengmei
//
//  Created by Q14 on 2018/9/28.
//  Copyright © 2018年 更美互动信息科技有限公司. All rights reserved.
//

#import "UIView+GMExtension.h"
#import "GMAlbumListViewController.h"
#import "GMPhotoTools.h"
@implementation UIView (GMExtension)

- (void)setGm_x:(CGFloat)gm_x
{
    CGRect frame = self.frame;
    frame.origin.x = gm_x;
    self.frame = frame;
}

- (CGFloat)gm_x
{
    return self.frame.origin.x;
}

- (void)setGm_y:(CGFloat)gm_y
{
    CGRect frame = self.frame;
    frame.origin.y = gm_y;
    self.frame = frame;
}

- (CGFloat)gm_y
{
    return self.frame.origin.y;
}

- (void)setGm_w:(CGFloat)gm_w
{
    CGRect frame = self.frame;
    frame.size.width = gm_w;
    self.frame = frame;
}

- (CGFloat)gm_w
{
    return self.frame.size.width;
}

- (void)setGm_h:(CGFloat)gm_h
{
    CGRect frame = self.frame;
    frame.size.height = gm_h;
    self.frame = frame;
}

- (CGFloat)gm_h
{
    return self.frame.size.height;
}

- (void)setGm_size:(CGSize)gm_size
{
    CGRect frame = self.frame;
    frame.size = gm_size;
    self.frame = frame;
}

- (CGSize)gm_size
{
    return self.frame.size;
}

- (void)setGm_origin:(CGPoint)gm_origin
{
    CGRect frame = self.frame;
    frame.origin = gm_origin;
    self.frame = frame;
}

- (CGPoint)gm_origin
{
    return self.frame.origin;
}

/**
 获取当前视图的控制器
 
 @return 控制器
 */
- (UIViewController*)viewController {
    for (UIView* next = [self superview]; next; next = next.superview) {
        UIResponder* nextResponder = [next nextResponder];
        if ([nextResponder isKindOfClass:[UINavigationController class]] || [nextResponder isKindOfClass:[UIViewController class]]) {
            return (UIViewController*)nextResponder;
        }
    }
    return nil;
}

- (void)gm_presentAlbumListViewControllerWithManager:(GMPhotoManager *)manager delegate:(id)delegate {
    GMAlbumListViewController *vc = [[GMAlbumListViewController alloc] init];
    vc.delegate = delegate ? delegate : (id)self;
    vc.manager = manager;
//    GMCustomNavigationController *nav = [[GMCustomNavigationController alloc] initWithRootViewController:vc];
//    nav.supportRotation = manager.configuration.supportRotation;
//    [self.viewController presentViewController:nav animated:YES completion:nil];
}

- (void)gm_presentCustomCameraViewControllerWithManager:(GMPhotoManager *)manager delegate:(id)delegate {
//    GMCustomCameraViewController *vc = [[GMCustomCameraViewController alloc] init];
//    vc.delegate = delegate ? delegate : (id)self;
//    vc.manager = manager;
//    vc.isOutside = YES;
//    GMCustomNavigationController *nav = [[GMCustomNavigationController alloc] initWithRootViewController:vc];
//    nav.isCamera = YES;
//    nav.supportRotation = manager.configuration.supportRotation;
//    [self.viewController presentViewController:nav animated:YES completion:nil];
}

- (void)showImageHUDText:(NSString *)text {
    CGFloat hudW = [GMPhotoTools getTextWidth:text height:15 fontSize:14];
    if (hudW > self.frame.size.width - 60) {
        hudW = self.frame.size.width - 60;
    }
    CGFloat hudH = [GMPhotoTools getTextHeight:text width:hudW fontSize:14];
    if (hudW < 100) {
        hudW = 100;
    }
    GMHUD *hud = [[GMHUD alloc] initWithFrame:CGRectMake(0, 0, hudW + 20, 110 + hudH - 15) imageName:@"alert_failed_icon" text:text];
    hud.alpha = 0;
    hud.tag = 1008611;
    [self addSubview:hud];
    hud.center = CGPointMake(self.frame.size.width / 2, self.frame.size.height / 2);
    [UIView animateWithDuration:0.25 animations:^{
        hud.alpha = 1;
    }];
    [UIView cancelPreviousPerformRequestsWithTarget:self];
    [self performSelector:@selector(handleGraceTimer) withObject:nil afterDelay:1.5f inModes:@[NSRunLoopCommonModes]];
}

- (void)showLoadingHUDText:(NSString *)text {
//    CGFloat hudW = [GMPhotoTools getTextWidth:text height:15 fontSize:14];
//    if (hudW > self.frame.size.width - 60) {
//        hudW = self.frame.size.width - 60;
//    }
//    CGFloat hudH = [GMPhotoTools getTextHeight:text width:hudW fontSize:14];
//    CGFloat width = 110;
//    CGFloat height = width + hudH - 15;
//    if (!text) {
//        width = 95;
//        height = 95;
//    }
//    GMHUD *hud = [[GMHUD alloc] initWithFrame:CGRectMake(0, 0, width, height) imageName:@"alert_failed_icon@2x.png" text:text];
//    [hud showloading];
//    hud.alpha = 0;
//    hud.tag = 10086;
//    [self addSubview:hud];
//    hud.center = CGPointMake(self.frame.size.width / 2, self.frame.size.height / 2);
//    [UIView animateWithDuration:0.25 animations:^{
//        hud.alpha = 1;
//    }];
}

- (void)handleLoading {
    [UIView cancelPreviousPerformRequestsWithTarget:self];
    for (UIView *view in self.subviews) {
        if (view.tag == 10086) {
            [UIView animateWithDuration:0.2f animations:^{
                view.alpha = 0;
            } completion:^(BOOL finished) {
                [view removeFromSuperview];
            }];
        }
    }
}

- (void)handleGraceTimer {
    [UIView cancelPreviousPerformRequestsWithTarget:self];
    for (UIView *view in self.subviews) {
        if (view.tag == 1008611) {
            [UIView animateWithDuration:0.2f animations:^{
                view.alpha = 0;
            } completion:^(BOOL finished) {
                [view removeFromSuperview];
            }];
        }
    }
}

@end

@interface GMHUD ()
@property (copy, nonatomic) NSString *imageName;
@property (copy, nonatomic) NSString *text;
@property (weak, nonatomic) UIImageView *imageView;
@end

@implementation GMHUD

- (instancetype)initWithFrame:(CGRect)frame imageName:(NSString *)imageName text:(NSString *)text {
    self = [super initWithFrame:frame];
    if (self) {
        self.text = text;
        self.imageName = imageName;
        self.layer.masksToBounds = YES;
        self.layer.cornerRadius = 5;
        self.backgroundColor = [[UIColor blackColor] colorWithAlphaComponent:0.85];
        [self setup];
    }
    return self;
}

- (void)setup {
    UIImageView *imageView = [[UIImageView alloc] initWithImage:[UIImage imageNamed:self.imageName]];
    [self addSubview:imageView];
    CGFloat imgW = imageView.image.size.width;
    CGFloat imgH = imageView.image.size.height;
    CGFloat imgCenterX = self.frame.size.width / 2;
    imageView.frame = CGRectMake(0, 20, imgW, imgH);
    imageView.center = CGPointMake(imgCenterX, imageView.center.y);
    self.imageView = imageView;
    
    UILabel *label = [[UILabel alloc] init];
    label.text = self.text;
    label.textColor = [UIColor whiteColor];
    label.textAlignment = NSTextAlignmentCenter;
    label.font = [UIFont gmFont:14];
    label.numberOfLines = 0;
    [self addSubview:label];
    CGFloat labelX = 10;
    CGFloat labelY = CGRectGetMaxY(imageView.frame) + 10;
    CGFloat labelW = self.frame.size.width - 20;
    CGFloat labelH = [GMPhotoTools getTextHeight:self.text width:labelW fontSize:14];
    label.frame = CGRectMake(labelX, labelY, labelW, labelH);
}

- (void)showloading {
    UIActivityIndicatorView *loading = [[UIActivityIndicatorView alloc] initWithActivityIndicatorStyle:UIActivityIndicatorViewStyleWhiteLarge];
    [loading startAnimating];
    [self addSubview:loading];
    if (self.text) {
        loading.frame = self.imageView.frame;
    }else {
        loading.frame = self.bounds;
    }
    self.imageView.hidden = YES;
}
@end

