//
//  UIViewController+GMExtension.h
//  GMAlbum
//
//  Created by Q4 on 2018/10/5.
//  Copyright © 2018年 Q14. All rights reserved.
//

#import <UIKit/UIKit.h>
#import "GMAlbumListViewController.h"
#import "GMCustomCameraViewController.h"

@interface UIViewController (GMExtension)
/*  <GMAlbumListViewControllerDelegate>
 *  delegate 不传则代表自己
 */
- (void)gm_presentAlbumListViewControllerWithManager:(GMPhotoManager *)manager delegate:(id)delegate;

/**
 跳转相册列表
 
 @param manager 照片管理者
 @param done 确定 NSArray<GMPhotoModel *> *allList - 所选的所有模型数组,
 NSArray<GMPhotoModel *> *videoList - 所选的视频模型数组
 NSArray<GMPhotoModel *> *photoList - 所选的照片模型数组
 NSArray<UIImage *> *imageList - 所选的所有UIImage对象数组(当requestImageAfterFinishingSelection = YES 时才有值,内部会在点击确定的时候去请求已经选择资源的图片，为视频时则是视频封面)
 BOOL original - 是否原图
 GMAlbumListViewController *viewController 相册列表控制器
 @param cancel 取消
 */
- (void)gm_presentAlbumListViewControllerWithManager:(GMPhotoManager *)manager done:(GMAlbumListViewControllerDidDoneBlock)done cancel:(GMAlbumListViewControllerDidCancelBlock)cancel;

/*  <GMCustomCameraViewControllerDelegate>
 *  delegate 不传则代表自己
 */
- (void)gm_presentCustomCameraViewControllerWithManager:(GMPhotoManager *)manager delegate:(id)delegate;

- (void)gm_presentCustomCameraViewControllerWithManager:(GMPhotoManager *)manager  done:(GMCustomCameraViewControllerDidDoneBlock)done cancel:(GMCustomCameraViewControllerDidCancelBlock)cancel;

- (BOOL)navigationBarWhetherSetupBackground;
@end


