//
//  UIViewController+GMExtension.m
//  GMAlbum
//
//  Created by Q4 on 2018/10/5.
//  Copyright © 2018年 Q14. All rights reserved.
//

#import "UIViewController+GMExtension.h"

@implementation UIViewController (GMExtension)
- (void)gm_presentAlbumListViewControllerWithManager:(GMPhotoManager *)manager delegate:(id)delegate {
    GMAlbumListViewController *vc = [[GMAlbumListViewController alloc] init];
    vc.referer = self.pageName;
    vc.delegate = delegate ? delegate : (id)self;
    vc.manager = manager;
    GMNavigationController *nav = [[GMNavigationController alloc] initWithRootViewController:vc];
    [self presentViewController:nav animated:YES completion:nil];
}

- (void)gm_presentAlbumListViewControllerWithManager:(GMPhotoManager *)manager done:(GMAlbumListViewControllerDidDoneBlock)done cancel:(GMAlbumListViewControllerDidCancelBlock)cancel {
    GMAlbumListViewController *vc = [[GMAlbumListViewController alloc] init];
    vc.referer = self.pageName;
    vc.manager = manager;
    vc.doneBlock = done;
    vc.cancelBlock = cancel;
    vc.delegate = (id)self;
    GMNavigationController *nav = [[GMNavigationController alloc] initWithRootViewController:vc];
    [self presentViewController:nav animated:YES completion:nil];
}

- (void)gm_presentCustomCameraViewControllerWithManager:(GMPhotoManager *)manager delegate:(id)delegate {
    GMCustomCameraViewController *vc = [[GMCustomCameraViewController alloc] init];
    vc.referer = self.pageName;
    vc.delegate = delegate ? delegate : (id)self;
    vc.manager = manager;
    vc.isOutside = YES;
    GMNavigationController *nav = [[GMNavigationController alloc] initWithRootViewController:vc];
    [self presentViewController:nav animated:YES completion:nil];
}

- (void)gm_presentCustomCameraViewControllerWithManager:(GMPhotoManager *)manager done:(GMCustomCameraViewControllerDidDoneBlock)done cancel:(GMCustomCameraViewControllerDidCancelBlock)cancel {
    GMCustomCameraViewController *vc = [[GMCustomCameraViewController alloc] init];
    vc.referer = self.pageName;
    vc.doneBlock = done;
    vc.cancelBlock = cancel;
    vc.manager = manager;
    vc.isOutside = YES;
    vc.delegate = (id)self;
    GMNavigationController *nav = [[GMNavigationController alloc] initWithRootViewController:vc];
    [self presentViewController:nav animated:YES completion:nil];
}

- (BOOL)navigationBarWhetherSetupBackground {
    if ([self.navigationController.navigationBar backgroundImageForBarMetrics:UIBarMetricsDefault]) {
        return YES;
    }else if ([self.navigationController.navigationBar backgroundImageForBarMetrics:UIBarMetricsCompact]) {
        return YES;
    }else if ([self.navigationController.navigationBar backgroundImageForBarMetrics:UIBarMetricsDefaultPrompt]) {
        return YES;
    }else if ([self.navigationController.navigationBar backgroundImageForBarMetrics:UIBarMetricsCompactPrompt]) {
        return YES;
    }else if (self.navigationController.navigationBar.backgroundColor) {
        return YES;
    }
    return NO;
}
@end
