//
//  GMShareSDK.h
//  Gengmei
//
//  Created by licong on 2017/8/16.
//  Copyright © 2017年 更美互动信息科技有限公司. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "NSMutableDictionary+GMShareSDK.h"

/**
 *  分享内容状态变更回调处理器
 *
 *  @param state            状态
 *  @param userData         附加数据, 返回状态以外的一些数据描述，如：邮件分享取消时，标识是否保存草稿等
 *  @param error            错误信息,当且仅当state为SSDKResponseStateFail时返回
 */
typedef void(^GMSDKShareStateChangedHandler) (GMShareResponseState state,  NSError *error);

@interface GMShareSDK : NSObject

+ (instancetype)shareInstance;

/** 判断微博、微信、QQ是否已经安装*/
+ (BOOL)isClientInstalled:(GMSharePlatform)platformType;

+ (UIImage *)compressWithUrl:(NSString *)url;

+ (UIImage *)compressImage:(UIImage *)image;

+ (NSString *)shareChannel:(GMSharePlatform)platformType;

- (void)share:(GMSharePlatform)platformType
   parameters:(NSMutableDictionary *)parameters
onStateChanged:(GMSDKShareStateChangedHandler)stateChangedHandler;

- (void)shareImage:(UIImage *)image platform:(GMSharePlatform)platformType;

@end
