//
//  GMThirdPartyDefine.h
//  Gengmei
//
//  Created by licong on 2017/8/2.
//  Copyright © 2017年 更美互动信息科技有限公司. All rights reserved.
//

#ifndef GMThirdPartyDefine_h
#define GMThirdPartyDefine_h

typedef NS_ENUM(NSInteger, GMShareResponseState) {
    GMShareResponseStateBegin           = -1,
    GMShareResponseStateSuccess         =  0,
    GMShareResponseStateFail            =  1,
    GMShareResponseStateCancel          =  2,
    GMShareResponseStateBack            =  3,
};

typedef NS_ENUM(NSInteger, GMSharePlatform) {
    GMSharePlatformUnknown          = -1,
    GMSharePlatformSinaWeibo        =  0,           /**< 新浪微博 */
    GMSharePlatformQQSpace          =  1,           /**< QQ空间 */
    GMSharePlatformQQFriend         =  2,           /**< QQ好友 */
    GMSharePlatformWechatSession    =  3,           /**< 微信好友 */
    GMSharePlatformWechatTimeline   =  4,           /**< 微信朋友圈 */

    GMSharePlatformFav      = 5,                    /**< 收藏 */
    GMSharePlatformDelete   = 6,                    /**< 删除 */
    GMSharePlatformCopyLink = 7,                    /**< 复制链接 */
    GMSharePlatformRefresh  = 8,                    /**< 刷新 */
    GMSharePlatformReport   = 9,                    /**< 举报 */
    GMSharePlatformCancelFollow = 10,               /**< 圈子取消关注 */
    GMSharePlatformWechatSessionSnapShot = 11,      /**< 微信好友快照 */
    GMSharePlatformWechatTimelineSnapShot = 12,     /**< 微信朋友圈快照 */
    GMSharePlatformWechatMiniProgram = 13,          /**< 微信小程序分享 */
    GMSharePlatformPrivateMsg = 14,          /**< 更美私信 */
    GMSharePlatformInviteAnswer = 15,               /** 邀请回复(回复详情和问题详情界面) */
    GMSharePlatformWechat              = 100,       /**< 微信平台*/
    GMSharePlatformQQ                  = 101,       /**< QQ平台*/
    GMSharePlatformEmail               = 102,       /**< Email平台*/
};


/**
 *  内容类型
 */
typedef NS_ENUM(NSUInteger, GMShareContentType){
    
    /**
     *  自动适配类型，视传入的参数来决定
     */
    GMShareContentTypeAuto         = 0,
    
    /**
     *  文本
     */
    GMShareContentTypeText         = 1,
    
    /**
     *  图片
     */
    GMShareContentTypeImage        = 2,
    
    /**
     *  网页
     */
    GMShareContentTypeWebPage      = 3,
    
    /**
     *  应用
     */
    GMShareContentTypeApp          = 4,
    
    /**
     *  音频
     */
    GMShareContentTypeAudio        = 5,
    
    /**
     *  视频
     */
    GMShareContentTypeVideo        = 6,
    
    /**
     *  文件类型(暂时仅微信可用)
     */
    GMShareContentTypeFile         = 7,
    
    //图片类型 仅FacebookMessage 分享图片并需要明确结果时 注此类型分享后不会显示应用名称与icon
    //v3.6.2 增加
    GMShareContentTypeFBMessageImages = 8,
    
    //图片类型 仅FacebookMessage 分享视频并需要明确结果时 注此类型分享后不会显示应用名称与icon
    //所分享的视频地址必须为相册地址
    //v3.6.2 增加
    GMShareContentTypeFBMessageVideo = 9,
    
    //3.6.3 小程序分享(暂时仅微信可用)
    GMShareContentTypeMiniProgram  = 10
};


#define kQQLogin         @"kQQLogin"
#define kSinaLogin       @"kSinaLogin"
#define kWechatLogin     @"kWechatLogin"

//QQ好友和朋友圈会掉的url完全一样，所以没必要区分 QQ41A1DB6D://response_from_qq?source=qq&source_scheme=mqqapi&error=0&version=1&sdkv=3.1
#define kQQShare               @"kQQShare"
#define kSinaShare             @"kSinaShare"
#define kWechatShare           @"kWechatShare"

#define kThirdPartyLoginBack     @"kThirdPartyLoginBack"
#define kThirdPartyShareBack     @"kThirdPartyShareBack"
#define WEICHAT_BASE_URL        @"https://api.weixin.qq.com/sns"

//有关登陆授权的一些key
#ifdef APPSTORE

#define WEIXIN_APPID                            @"wx4ea9555dcef5f876"                   //WeiXin appId
#define WEIXIN_SECRET                           @"87c15ff164c597701c6f1c4da36df5ab"     //WeiXin secret

#else

#define WEIXIN_APPID                            @"wx4ea9555dcef5f876"                   //WeiXin appId
#define WEIXIN_SECRET                           @"87c15ff164c597701c6f1c4da36df5ab"     //WeiXin secret

#endif

#define QQ_APPID                                @"101519397"                           //QQ APPID
#define QQ_HEX_APPID                            @"41A1DB6D"                             //16进制的QQ appid
#define QQ_APPKEY                               @"8413682749ce21a261bc5ebecaff72f4"                     //QQ APPKEY

#define SINAWEIBO_APPID                         @"3033997989"                           //Sina Weibo APPKEY
#define SINAWEIBO_APPKEY                        @"af24f2cf05daffdf3132cdd4b0378773"     //Sina Weibo secret
#define SINAWEIBO_REDIRECTURI                   @"https://api.weibo.com/oauth2/default.html"// 授权回调页


#endif /* GMThirdPartyDefine_h */
