//
//  GMThirdPartyLoginHelper.m
//  Gengmei
//
//  Created by licong on 2017/8/2.
//  Copyright © 2017年 更美互动信息科技有限公司. All rights reserved.
//

#import "GMThirdPartyLoginHelper.h"
#import "WXApi.h"
//#import <GMShareSDK.h>
//#import <Weibo_SDK/WeiboSDK.h>
#import "GMThirdPartyDefine.h"
#import "GMThirdPartyOauthManager.h"

@implementation GMThirdPartyUser

@end

@implementation GMThirdPartyLoginHelper


+ (void)loginByPlatform:(GMSharePlatform)platform
             onUserSync:(GMThirdPartyUserHandler)userHandler{
    [GMThirdPartyOauthManager shareInstance].user.platformType = platform;
    if (platform == GMSharePlatformQQ) {
        NSArray* permissions = [NSArray arrayWithObjects:
                                kOPEN_PERMISSION_GET_USER_INFO,
                                kOPEN_PERMISSION_GET_SIMPLE_USER_INFO,
                                nil];
        [[GMThirdPartyOauthManager shareInstance].tencentOAuth setAuthShareType: AuthShareType_QQ];
        [[GMThirdPartyOauthManager shareInstance].tencentOAuth authorize:permissions inSafari:NO];
        __block id observer = [[NSNotificationCenter defaultCenter] addObserverForName:kQQLogin object:nil queue: [NSOperationQueue mainQueue] usingBlock:^(NSNotification * _Nonnull note) {
            GMShareResponseState state = (GMShareResponseState )[note.userInfo[@"state"] integerValue];
            userHandler(state, note.object);
            [[NSNotificationCenter defaultCenter] removeObserver:observer];
        }];
    } else if (platform == GMSharePlatformWechat) {
        if ([WXApi isWXAppInstalled]){
            [GMThirdPartyLoginHelper wechatLogin];
            __block id observer = [[NSNotificationCenter defaultCenter] addObserverForName:kWechatLogin object:nil queue: [NSOperationQueue mainQueue] usingBlock:^(NSNotification * _Nonnull note) {
                GMShareResponseState state = (GMShareResponseState )[note.userInfo[@"state"] integerValue];
                userHandler(state, note.object);
                [[NSNotificationCenter defaultCenter] removeObserver:observer];
            }];
        }
    } else if (platform  == GMSharePlatformSinaWeibo){
        WBAuthorizeRequest *request = [WBAuthorizeRequest request];
        request.redirectURI = SINAWEIBO_REDIRECTURI ;
        request.scope = @"all";
        request.userInfo = @{@"flag": @"authorize"};
        [WeiboSDK sendRequest:request];
        __block id observer = [[NSNotificationCenter defaultCenter] addObserverForName:kSinaLogin object:nil queue: [NSOperationQueue mainQueue] usingBlock:^(NSNotification * _Nonnull note) {
            GMShareResponseState state = (GMShareResponseState )[note.userInfo[@"state"] integerValue];
            userHandler(state, note.object);
            [[NSNotificationCenter defaultCenter] removeObserver:observer];
        }];
    }
}

+ (void)wechatLogin {
    if ([WXApi isWXAppInstalled]){
        //构造SendAuthReq结构体
        SendAuthReq* req = [[SendAuthReq alloc ] init];
        req.scope = @"snsapi_userinfo" ;
        req.state = @"Gengmei" ;
        //第三方向微信终端发送一个SendAuthReq消息结构
        [WXApi sendReq:req];
    }
}

+ (void)thirdPartyLogout {
    if ([GMThirdPartyOauthManager shareInstance].user.platformType == GMSharePlatformQQ){
        [GMThirdPartyOauthManager shareInstance].tencentOAuth = [[TencentOAuth alloc] initWithAppId:QQ_APPID andDelegate:[GMThirdPartyOauthManager shareInstance]];
    }
    
}

@end
