//
//  NSMutableDictionary+GMShareSDK.h
//  Gengmei
//
//  Created by licong on 2017/8/18.
//  Copyright © 2017年 更美互动信息科技有限公司. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "GMThirdPartyDefine.h"
#import "WXApiObject.h"

@interface NSMutableDictionary (GMShareSDK)

/**
 *  设置分享参数
 *
 *  @param text     文本
 *  @param images   图片集合,传入参数可以为单张图片信息，也可以为一个NSArray，数组元素可以为UIImage、NSString（图片路径）、NSURL（图片路径）、SSDKImage。如: @"http://www.mob.com/images/logo_black.png" 或 @[@"http://www.mob.com/images/logo_black.png"]
 *  @param url      网页路径/应用路径
 *  @param title    标题
 *  @param type     分享类型
 */
- (void)shareSetupShareParamsByText:(NSString *)text
                            images:(id)images
                               url:(NSURL *)url
                             title:(NSString *)title
                              type:(GMShareContentType)type;

/**
 *  设置微信小程序分享参数
 *
 *  @param text         网页路径/应用路径
 *  @user name          小程序的原始id
 *  @user path          小程序页面的路径
 *  @param title        小程序标题
 *  @param description  小程序描述
 *  @param thumbImage   缩略图
 *  @param hdImageData  小程序节点高清大图，小于128k

 */
- (void)shareSetupMiniProgramShareParamsByUrl:(NSString *)url
                                     userName:(NSString *)userName
                                         path:(NSString *)path
                                        title:(NSString *)title
                                  description:(NSString *)description
                                   thumbImage:(NSString *)thumbImage
                                  hdImageData:(NSString *)hdImageData;

@end
