//
// MDCSwipeToChooseView.m
//
// Copyright (c) 2014 to present, Brian Gesiak @modocache
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.
//

#import "MDCSwipeToChooseView.h"
#import "MDCSwipeToChoose.h"
#import "MDCGeometry.h"
#import "UIColor+MDCRGB8Bit.h"
#import <QuartzCore/QuartzCore.h>

static CGFloat const MDCSwipeToChooseViewHorizontalPadding = 10.f;
static CGFloat const MDCSwipeToChooseViewTopPadding = 10.f;
static CGFloat const MDCSwipeToChooseViewLabelWidth = 88.f;

#define kLikeImageViewWH  39
@interface MDCSwipeToChooseView ()
@property (nonatomic, strong) MDCSwipeToChooseViewOptions *options;
@end

@implementation MDCSwipeToChooseView

#pragma mark - Object Lifecycle

- (instancetype)initWithFrame:(CGRect)frame options:(MDCSwipeToChooseViewOptions *)options {
    self = [super initWithFrame:frame];
    if (self) {
        _options = options ? options : [MDCSwipeToChooseViewOptions new];
        [self setupView];
        [self constructImageView];
        [self constructLikedView];
        [self constructNopeImageView];
        [self setupSwipeToChoose];
    }
    return self;
}

#pragma mark - Internal Methods

- (void)setupView {
    self.backgroundColor = [UIColor clearColor];
}

- (void)constructImageView {
    _contentView = [[UIView alloc] initWithFrame:self.bounds];
    _contentView.clipsToBounds = YES;
    [self addSubview:_contentView];
}

- (void)constructLikedView {
    CGFloat width = MDCSwipeToChooseViewLabelWidth;
    CGFloat space = (width - kLikeImageViewWH)/2;
    CGRect frame = CGRectMake(MDCSwipeToChooseViewHorizontalPadding,
                              MDCSwipeToChooseViewTopPadding,
                              width,
                              width);
    self.likedView = [[UIView alloc] initWithFrame:frame];
    self.likedView.backgroundColor = [UIColor whiteColor];
    UIImageView *likeImageView = [[UIImageView alloc] initWithFrame:CGRectMake(space, space, kLikeImageViewWH, kLikeImageViewWH)];
    likeImageView.tag = 1001;
    likeImageView.image = [UIImage imageNamed:@"pick_like"];
    [self.likedView addSubview:likeImageView];
    self.likedView.layer.masksToBounds = YES;
    self.likedView.layer.cornerRadius = width/2;
    self.likedView.alpha = 0.f;
    [self.contentView addSubview:self.likedView];
}

- (void)constructNopeImageView {
    CGFloat width = MDCSwipeToChooseViewLabelWidth;
    CGFloat xOrigin = self.contentView.bounds.size.width - width - MDCSwipeToChooseViewHorizontalPadding;
    CGFloat space = (width - kLikeImageViewWH)/2;
    self.nopeView = [[UIView alloc] initWithFrame:CGRectMake(xOrigin,
                                                                  MDCSwipeToChooseViewTopPadding,
                                                                  width,
                                                                  width)];
    self.nopeView.backgroundColor = [UIColor whiteColor];
    UIImageView *unlikeImageView = [[UIImageView alloc] initWithFrame:CGRectMake(space, space, kLikeImageViewWH, kLikeImageViewWH)];
    unlikeImageView.tag = 1001;
    unlikeImageView.image = [UIImage imageNamed:@"pick_unlike"];
    [self.nopeView addSubview:unlikeImageView];
    self.nopeView.layer.masksToBounds = YES;
    self.nopeView.layer.cornerRadius = width/2;
    self.nopeView.alpha = 0.f;
    [self.contentView addSubview:self.nopeView];
}

- (void)setupSwipeToChoose {
    MDCSwipeOptions *options = [MDCSwipeOptions new];
    options.delegate = self.options.delegate;
    options.threshold = self.options.threshold;

    __block UIView *likedImageView = self.likedView;
    __block UIView *nopeImageView = self.nopeView;
    __weak MDCSwipeToChooseView *weakself = self;
    options.onPan = ^(MDCPanState *state) {
        if (state.direction == MDCSwipeDirectionNone) {
            likedImageView.alpha = 0.f;
            nopeImageView.alpha = 0.f;
        } else if (state.direction == MDCSwipeDirectionLeft) {
            likedImageView.alpha = 0.f;
            nopeImageView.alpha = state.thresholdRatio;
        } else if (state.direction == MDCSwipeDirectionRight) {
            likedImageView.alpha = state.thresholdRatio;
            nopeImageView.alpha = 0.f;
        }

        if (weakself.options.onPan) {
            weakself.options.onPan(state);
        }
    };

    [self mdc_swipeToChooseSetup:options];
}

@end
