//
//  U2DCamera.h
//  Unre2DScan
//
//  Created by MikeYu on 2018/11/27.
//  Copyright © 2018 unre. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <AVFoundation/AVFoundation.h>
#import <UIKit/UIKit.h>

NS_ASSUME_NONNULL_BEGIN
/**
 Device orientation
 now only support:
 Unre2DCameraVideoOrientationPortraitDefault
 Unre2DCameraVideoOrientationPortraitUp
 */
typedef NS_ENUM(NSInteger, Unre2DCameraVideoOrientation) {
    Unre2DCameraVideoOrientationPortraitDefault,
    Unre2DCameraVideoOrientationPortraitUp
    //Unre3DCameraVideoOrientationPortraitDown,
    //Unre3DCameraVideoOrientationLandscapeLeft,
    //Unre3DCameraVideoOrientationLandscapeRight
} NS_SWIFT_NAME(Unre2DCamera.VideoOrientation);

OBJC_VISIBLE @interface U2DCamera : NSObject

+ (instancetype)new NS_UNAVAILABLE;
- (instancetype)init NS_UNAVAILABLE;

/**
 *    @brief    return ture  if  it's a depth camera
 */
@property (nonatomic, readonly) BOOL supportsCameraCapturing;

/**
 *    @brief    Initialization method
 *
 *    @param     orientation     Unre2DCameraVideoOrientation type
 *
 *    @return    orientation    Device orientation
 */
- (instancetype)initWithVideoOrientation:(Unre2DCameraVideoOrientation)orientation;


/**
 *    @brief    Starts camera streaming. This will request camera permissions
 *
 *    @param     preview Preview interface
 */
- (void)startStreaming:(UIView *)preview;

/**
 *    @brief    Stops camera streaming.
 */
- (void)stopStreaming;

- (void)enableLog:(BOOL) enable;

@end

NS_ASSUME_NONNULL_END


