//
//  U2DHeadNetModel.h
//  Unre2DScanLib
//
//  Created by MikeYu on 2018/11/28.
//  Copyright © 2018 unre. All rights reserved.
//

#import <Foundation/Foundation.h>


NS_ASSUME_NONNULL_BEGIN

/**
 The Model params with image
 */
typedef struct U2DModelTF {
    double tfMat[9];
} U2DModelTF;


@interface U2DHeadNetModel : NSObject

/**
 *    @brief    Cutting image for server-adapted
 *
 *    @param    inImgFile     source img file
 *    @param    netImgFile    format img by server
 *    @param    uvImgFile     UV img by exportObj Model
 *    @param    tf        （struct）generat relationship  by image and model
 *
 *    @return   is detec face
 */
- (BOOL)formatNetImageWithInImgFile:(NSString *)inImgFile andnetImgFile:(NSString *)netImgFile uvImgFile:(NSString*)uvImgFile getModelTF:(U2DModelTF *)tf;

/**
 *    @brief    Generating model
 *
 *    @param    outPath      output OBJ path
 *    @param    objFile      output OBJ name (xxxx.obj)
 *    @param    netMatFile   model Mat from server
 *    @param    tf         （struct）relationship  by image and model from "formatNetImageWithInImgFile"
 *    @param    uvImgFile     UV img from "formatNetImageWithInImgFile:"
 *
 *    @return   success
 */
- (BOOL)exportNetDataToObjWithoutPath:(NSString *)outPath objFileName:(NSString*)objFile andNetMatFile:(NSString *)netMatFile modelTF:(U2DModelTF *)tf uvImgFile:(NSString *)uvImgFile;

@end

NS_ASSUME_NONNULL_END
