//
//  H2DHeadScannerPro.h
//  Unre2DScanLib
//
//  Created by MikeYu on 2018/11/28.
//  Copyright © 2018 unre. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

NS_SWIFT_NAME(Unre2DHeadScanner.ProgressInfo)
OBJC_VISIBLE @interface Unre2DHeadScannerProgressInfo : NSObject


/**
 *    @brief   The largest right position head has reached during scan. Gets values from range [0; 1],
 where 1 corresponds to rightmost position, 0 corresponds to central position.
 */
@property (nonatomic, readonly) float maxReachedHeadPosition;




/**
 *    @brief    The largest left position head has reached during scan. Gets values from range [-1; 0],where -1 corresponds to leftmost position, 0 corresponds to central position.
 */
@property (nonatomic, readonly) float minReachedHeadPosition;





/**
 *    @brief    Head position at what the head currently is. Gets values from range [-1; 1],where -1 corresponds to leftmost position, 0 corresponds to central position and 1 corresponds to rightmost position.
 */
@property (nonatomic, readonly) float currentHeadPosition;





/**
 *    @brief    Guiding position that head should be at. Gets values from range [0; 4],where each integer value means change of the direction of rotation.
 
 
 */
@property (nonatomic, readonly) float targetPosition;

@end


NS_ASSUME_NONNULL_END
