//
//  U2DSessionData.h
//  Unre2DScan
//
//  Created by MikeYu on 2018/11/27.
//  Copyright © 2018 unre. All rights reserved.
//


#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

OBJC_VISIBLE @interface U2DSessionData : NSObject

+ (instancetype)new NS_UNAVAILABLE;
- (instancetype)init NS_UNAVAILABLE;

//@property (nonatomic, readonly) BOOL empty;
@property (nonatomic, readonly, nullable) NSString *sessionID;


/**
 *    @brief    Root directory containing session working directories
 
 */
@property (nonatomic, readonly, nullable) NSString *rootSessionDirectory;

/**
 *    @brief    Loads session with the specified ID as a current one
 *
 *    @param     sessionID     also as the file name
 *
 *    @return    return value description
 */
+ (instancetype)dataWithID:(NSString *)sessionID;

/**
 *    @brief    initWithID
 *
 *    @param     sessionID     the specified ID
 *    @param     outError      NSError
 *
 *    @return    <#return value description#>
 */
- (instancetype)initWithID:(NSString *)sessionID error:(NSError ** _Nullable)outError;

/**
 *    @brief    Removes rootSessionDirectory
 */
- (void)clear;

@end

NS_ASSUME_NONNULL_END
