//
//  U3DCamera.h
//  UnreScan
//
//  Created by Simon on 2018/10/23.
//  Copyright © 2018 Unretek. All rights reserved.
//

#ifndef U3DCamera_h
#define U3DCamera_h
#import <UIKit/UIKit.h>
#import <Foundation/Foundation.h>
#import <AVFoundation/AVFoundation.h>
NS_ASSUME_NONNULL_BEGIN
/**
Device orientation
now only support:
Unre3DCameraVideoOrientationPortraitDefault
Unre3DCameraVideoOrientationPortraitUp
  */
typedef NS_ENUM(NSInteger, Unre3DCameraVideoOrientation) {
    Unre3DCameraVideoOrientationPortraitDefault,
    Unre3DCameraVideoOrientationPortraitUp,
    Unre3DCameraVideoOrientationPortraitDown,
    Unre3DCameraVideoOrientationLandscapeLeft,
    Unre3DCameraVideoOrientationLandscapeRight
} NS_SWIFT_NAME(Unre3DCamera.VideoOrientation);

OBJC_VISIBLE @interface Unre3DCamera : NSObject

+ (instancetype)new NS_UNAVAILABLE;
- (instancetype)init NS_UNAVAILABLE;



/**
 *    @brief    Initialization method
 *
 *    @param     orientation     Unre3DCameraVideoOrientation type
 *
 *    @return    orientation    Device orientation
 */
- (instancetype)initWithVideoOrientation:(Unre3DCameraVideoOrientation)orientation;




/**
 *    @brief    return ture  if  it's a depth camera
 */
@property (nonatomic, readonly) BOOL supportsDepthDataCapturing;




/**
 *    @brief    Starts camera streaming. This will request camera permissions
 *
 *    @param     preview Preview interface
 */
- (void)startStreaming:(UIView *)preview;



/**
 *    @brief    Stops camera streaming. 
 */
- (void)stopStreaming;



@end

NS_ASSUME_NONNULL_END

#endif /* U3DCamera_h */
