//
//  U3DHeadMesh.h
//  UnreScan
//
//  Created by Simon on 2018/10/24.
//  Copyright © 2018 Unretek. All rights reserved.
//

#ifndef U3DHeadMesh_h
#define U3DHeadMesh_h
//#import "U3DHeadProcessorSettings.h"

NS_ASSUME_NONNULL_BEGIN



OBJC_VISIBLE @interface Unre3DHeadMesh : NSObject


/**
 *    @brief    return ture  if  processWithSessionData success
 */
@property (nonatomic, readonly) BOOL isSuccess;


/**
*    @brief    Export the mesh files with texture map to the customer directory.
               The *.obj file name type are supported.

*    @param     path     Directory where to generate file
*    @param     filename     Name of file with extension(Without suffix)
*    @param     error     NSError*
*
*    @return    return    return ture if saved successfully
*/

- (BOOL)exportMeshFilesToDirectoryAtPATH:(NSString *)path filename:(NSString *)filename error:(NSError ** _Nullable)error;

@end

NS_ASSUME_NONNULL_END

#endif /* U3DHeadMesh_h */
