//
//  U3DHeadProcessor.h
//  UnreScan
//
//  Created by Simon on 2018/10/24.
//  Copyright © 2018 Unretek. All rights reserved.
//

#ifndef U3DHeadProcessor_h
#define U3DHeadProcessor_h

#import "U3DSessionData.h"
#import "U3DHeadMesh.h"

NS_ASSUME_NONNULL_BEGIN

/**
 The texture type of
 */
typedef NS_ENUM(NSInteger, Unre3DTextureType) {
    Unre3DTextureTypePoisson,
    Unre3DTextureTypeGradual
};



@protocol Unre3DHeadProcessorObserver;
@class Unre3DHeadScannerSessionData, Unre3DHeadMesh;

/**
 The purpose of this Class is  produce 3D model of head using series of scanned images containing
depth and color information.
 */
OBJC_VISIBLE @interface Unre3DHeadProcessor : NSObject






/**
 *    @brief    add process callback
 *
 *    @param     observer     observer callback
 */
- (void)addObserver:(id<Unre3DHeadProcessorObserver>)observer NS_SWIFT_NAME(addObserver(_:));





/**
 *    @brief    remove process callback
 *
 *    @param     observer     observer callback
 */
- (void)removeObserver:(id<Unre3DHeadProcessorObserver>)observer NS_SWIFT_NAME(removeObserver(_:));




/**
 *    @brief    Start processing data to generate obj files.
 *    @param     sessionData     Unre3DHeadScannerSessionData The Scan rootDir data
 */
- (void)processWithSessionData:(Unre3DHeadScannerSessionData *)sessionData;

/**
 *    @brief    texture smooth and whitten ratio
 *
 *    @param     ratio     Effect Ratio
 */
- (void)setEffectRadio:(float)ratio;

/**
 *    @brief    texture type
 *
 *    @param     type     type of texture
 */
- (void)setUnre3DTextureType:(Unre3DTextureType)type;
/**
 *    @brief    model mesh level
 *
 *    @param    mlevel     mesh level
 */
- (void)setModelMeshLevel:(int)mlevel;

/**
 *    @brief    is use ReTextureNose
 *
 *    @param    reTextureNose     ReTexture Nose
 */
- (void)enableReTextureNose:(BOOL)isReTextureNose;

/**
 *    @brief    stop processing model
 */
- (void)stopProcessModel;

/**
 *    @brief    is create mesh now(if is generate ,can not scan)
 *
 */
+ (BOOL)isProcessing;


@end

OBJC_VISIBLE @protocol Unre3DHeadProcessorObserver<NSObject>

@optional





/**
 *    @brief    Display processing by percentage
 *
 *    @param     progress     range(0%~100%)(0~1)
 */
- (void)didReportProgress:(float)progress;






/**
 *    @brief    process complete
 *
 *    @param     headMesh     the class support a export method
 */
- (void)didCompleteProcessingWithMesh:(nullable Unre3DHeadMesh *)headMesh;

/**
 *    @brief     process complete
 *
 *    @param     success      the model process is complete
 *    @param     headMesh     the class support a export method
 */
//- (void)didCompleteProcessingWithSuccess:(BOOL)success andMesh:(Unre3DHeadMesh *)headMesh;




/**
 *    @brief    process error
 *
 *    @param     error     Error information
 */
- (void)didEncounterError:(nullable NSError *)error;


@end
NS_ASSUME_NONNULL_END
#endif /* U3DHeadProcessor_h */
