//
//  U3DHeadScannerProgress.h
//  UnreScan
//
//  Created by Simon on 2018/10/24.
//  Copyright © 2018 Unretek. All rights reserved.
//

#ifndef U3DHeadScannerProgressInfo_h
#define U3DHeadScannerProgressInfo_h

NS_ASSUME_NONNULL_BEGIN



NS_SWIFT_NAME(Unre3DHeadScanner.ProgressInfo)
OBJC_VISIBLE @interface Unre3DHeadScannerProgressInfo : NSObject



/**
*    @brief   The largest right position head has reached during scan. Gets values from range [0; 1],
              where 1 corresponds to rightmost position, 0 corresponds to central position.
*/
@property (nonatomic, readonly) float maxReachedHeadPosition;




/**
 *    @brief    The largest left position head has reached during scan. Gets values from range [-1; 0],where -1 corresponds to leftmost position, 0 corresponds to central position.
 */
@property (nonatomic, readonly) float minReachedHeadPosition;





/**
 *    @brief    Head position at what the head currently is. Gets values from range [-1; 1],where -1 corresponds to leftmost position, 0 corresponds to central position and 1 corresponds to rightmost position.
 */
@property (nonatomic, readonly) float currentHeadPosition;





/**
 *    @brief    Guiding position that head should be at. Gets values from range [0; 4],where each integer value means change of the direction of rotation.


 */
@property (nonatomic, readonly) float targetPosition;


@end

NS_ASSUME_NONNULL_END
#endif /* U3DHeadScannerProgress_h */
