//
//  U3DHeadSimilarity.h
//  UnreScanLib
//
//  Created by chenxinguo on 2018/11/26.
//  Copyright © 2018 unre. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <UIKit/UIKit.h>
#import <AVFoundation/AVFoundation.h>

NS_ASSUME_NONNULL_BEGIN


typedef NS_ENUM(NSInteger, CAPTURE_STATESIMILAR){
    StateSimilarIdle,
    StateSimilarTracking,
    StateSimilarSave
} ;



@protocol Unre3DHeadSimilarityObserver <NSObject>

@optional



@end

OBJC_VISIBLE @interface U3DHeadSimilarity : NSObject

@property (nonatomic, strong) UIView * preView;


- (void)addheadsimilarObserver:(id<Unre3DHeadSimilarityObserver>) headsimilarObs;

- (void)removeheadsimilarObserver:(id<Unre3DHeadSimilarityObserver>)observer NS_SWIFT_NAME(removeObserver(_:));



/**
 *    @brief This function will output a picture in the documents/UnreTest-XXXXXX/XXXX_similaroutput.bmp directory ，
 *    
 */

-(void) getheadsimilarimg:(NSString*) inputbpicpath;
@end

NS_ASSUME_NONNULL_END
