//
//  UneSessionData.h
//  UnreScan
//
//  Created by Simon on 2018/10/24.
//  Copyright © 2018 Unretek. All rights reserved.
//

#ifndef UneSessionData_h
#define UneSessionData_h
/**
//UnreScannerSession for the session for unre scanner
//     root session     current session folder    subfoler     files
//
//      data            data_0001(session id)     depth        depth_%d.png
//                                                image        img_%d.png
//                                                pose         pose%d.txt         pose file for each depth image
//                                                calib.txt

//                      data_002(session id)
 */
NS_ASSUME_NONNULL_BEGIN

OBJC_VISIBLE @interface Unre3DHeadScannerSessionData : NSObject

+ (instancetype)new NS_UNAVAILABLE;
- (instancetype)init NS_UNAVAILABLE;

//@property (nonatomic, readonly) BOOL empty;
@property (nonatomic, readonly, nullable) NSString *sessionID;




/**
 *    @brief    Root directory containing session working directories
 
 */
@property (nonatomic, readonly, nullable) NSString *rootSessionDirectory;





/**
 *    @brief    Loads session with the specified ID as a current one
 *
 *    @param     sessionID     also as the file name
 *
 *    @return    return value description
 */
+ (instancetype)dataWithID:(NSString *)sessionID;





/**
 *    @brief    initWithID
 *
 *    @param     sessionID     the specified ID
 *    @param     outError      NSError
 *
 *    @return    <#return value description#>
 */
- (instancetype)initWithID:(NSString *)sessionID error:(NSError ** _Nullable)outError;




/**
 *    @brief    Removes rootSessionDirectory
 */
- (void)clear;


@end

NS_ASSUME_NONNULL_END

#endif
