//
//  UnreSettings.h
//  UnreScanLib
//
//  Created by kristil on 2018/11/7.
//  Copyright © 2018年 unre. All rights reserved.
//

#import <Foundation/Foundation.h>

//NS_ASSUME_NONNULL_BEGIN
@protocol Unre3DStateChangeListener;
typedef NS_ENUM(NSInteger, ScannerState) {
    ScannerStateIdle,
    ScannerStateTracking,
    ScannerStateScanning,
    ScannerStateProcessing
} NS_SWIFT_NAME(Unre3DHeadScanner.State);

@interface Unre3DSettings : NSObject

+ (void)enableU3DLog:(BOOL)enLog;

+ (NSString *)getU3DVersion;

+ (void)addStateChangeListener:(id<Unre3DStateChangeListener>) listener;
+ (void)removeStateChangeListener:(id<Unre3DStateChangeListener>) listener;
+ (ScannerState)getCurrentScannerState;



@end

OBJC_VISIBLE @protocol Unre3DStateChangeListener<NSObject>

@optional


- (void)onStateChange:(ScannerState)state;



@end



//NS_ASSUME_NONNULL_END
