//
//  FileDataUtils.h
//  SDKDemo
//
//  Created by JasWorkSpace on 2018/10/23.
//  Copyright © 2018 JasWorkSpace. All rights reserved.
//

#ifndef FileDataUtils_h
#define FileDataUtils_h

#import <SceneKit/SceneKit.h>

#include "UnreDataStructure.h"

//// 如下提供的 API 都为对 FileData 数据进行校验，请自行确保 FileData 的正确性
@interface FileDataUtils : NSObject

+ (SCNGeometrySource *) createSCNGeometrySourceVertex:(struct UnreFileData_out *) data;//v
+ (SCNGeometrySource *) createSCNGeometrySourceTexcoord:(struct UnreFileData_out *) data;//vt
+ (SCNGeometrySource *) createSCNGeometrySourceColor:(struct UnreFileData_out *) data;//color
+ (SCNGeometrySource *) createSCNGeometrySourceNormal:(struct UnreFileData_out *) data;//vn
+ (SCNGeometryElement*) createSCNGeometryElement:(struct UnreFileData_out *) data;//f
///////////////////////////////////////////////////////////////////
+ (SCNGeometry *) createSCNGeometry:(struct UnreFileData_out *) data;
+ (SCNGeometry *) createColorSCNGeometry:(struct UnreFileData_out *) data;//color
+ (SCNNode *) createSCNNode:(struct UnreFileData_out *) data;
+ (SCNNode *) createColorSCNNode:(struct UnreFileData_out *) data;//color
@end

#endif /* FileDataUtils_h */

