//
//  UnreDataStructure.h
//  unreface_trans
//
//  Copyright © 2018 朱俊青. All rights reserved.
//

#ifndef UnreDataStructure_h
#define UnreDataStructure_h

#include <iostream>
#include <fstream>
#include <sstream>
#include <vector>


/**
 Unre face transform location
 */
#define LIPS_SMILE 0
#define LIPS_UP 1
#define LIPS_DOWN 2
#define NOSE_BRIDGE 3
#define NOSE_FAT 4
#define VFACE 5
#define FOREHEAD 6
#define EXTERNAL_CANTHUS 7
#define MEDIAL_CANTHUS 8
#define APPLE_MUSCLE 9
#define UP_CHIN 10
#define DOWN_CHIN 11
/** 客户部分去除 uv图处理部分，请勿传入如下值
#define SMOOTH_POUCH 12
#define PARALLEL_EYELID 13
#define FAN_EYELID 14
#define MOON_EYELID 15
#define WESTERN_EYELID 16
#define WHITENING 17
#define SMOOTH_UV 18

**/


using namespace std;

struct UnrePoint3D{float x,y,z;};
struct UnrePoint2D{float x,y;};
struct UnreFace3D{int x,y,z;};

/**
 Unre  face landmarks struct
 */
struct UnreFaceLandMarks{
    vector<UnrePoint3D> unre3DLandmark;
};

/**
 Unre face data struct
 */
struct UnreFileData_out {
    vector<UnrePoint2D> texcoords;
    vector<UnreFace3D> faces;
    vector<UnrePoint3D> v;
    vector<UnrePoint3D> vn;
    vector<UnrePoint3D> color;
    vector<UnrePoint2D> landmark2d;
    string uvImagePath;
    int facecount;
};
#endif /* UnreDataStructure_h */
