//
//  UnreDeformationControlManager.h
//  unreface_trans
//
//  Created by 朱俊青 on 2018/11/9.
//  Copyright © 2018 朱俊青. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <SceneKit/SceneKit.h>
#include "UnreDataStructure.h"

NS_ASSUME_NONNULL_BEGIN

@interface UnreDeformationControlManager : NSObject

/**
 get middle face datas from two fitted face

 @param sourceFaceData A face data address of UnreFileData_out
 @param destinationFaceData B face data address of UnreFileData_out
 @param step the number of middle face   >1
 @return the gather of middle face data
 */
+ (vector<UnreFileData_out>) unreExchangeFace:(struct UnreFileData_out *)sourceFaceData andTo:(struct UnreFileData_out *)destinationFaceData andStep:(int)step;


/**
 get one face datas from two fitted face

 @param sourceFaceData A face data address of UnreFileData_out
 @param destinationFaceData B face data address of UnreFileData_out
 @param rate the percent of middle face  0<rate<100
 @return one middle face data
 */
+ (UnreFileData_out)UnreMiddleFace:(struct UnreFileData_out *)sourceFaceData andTo:(struct UnreFileData_out *)destinationFaceData andRate:(int)rate;

+ (BOOL) saveUnreEncodingFace:(struct UnreFileData_out *) EncodingFaceData andPath:(NSString *)savePath;


/**
 save unreface data

 @param unrefaceObjData the address of need save UnreFileData_out
 @param savePath the path to save
 @return saved or not
 */
+ (BOOL)saveUnreObjData:(struct UnreFileData_out *) unrefaceObjData andPath:(NSString *)savePath;



+ (NSString *)getUnreTransSdkVersion;

@end

NS_ASSUME_NONNULL_END
