//
//
//
//
//  Created by 朱俊青 on 2018/10/30.
//  Copyright © 2018 朱俊青. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <SceneKit/SceneKit.h>
#include "UnreDataStructure.h"

NS_ASSUME_NONNULL_BEGIN

@protocol UnreDeformationManagerDegelate <NSObject>
- (void) unreDeformationManagerLoadFinish:(BOOL)result;
@end

@interface UnreDeformationManager : NSObject
@property(nonatomic,weak)id<UnreDeformationManagerDegelate> UnreDeformationManagerDelegate;
////////////////////

@property(nonatomic,strong) NSString * srcOBJFile;
@property(nonatomic,strong) NSString * srcMeshFile;
@property(nonatomic,strong) NSString * detectorFile;



/**
 the constructor of UnreDeformationManager
 @param objFilePath the objFile data path
 @param uvMapFilePath the uvMap Data path
 @return a object of UnreDeformationManager
 */
- (instancetype)initUnreFaceFile:(NSString *)objFilePath andUVmap:(NSString *) uvMapFilePath;

/**
 the constructor of UnreDeformationManager

 @param objFilePath the color point face data path
 @return a object of UnreDeformationManager
 */
- (instancetype)initUnreFaceFileColor:(NSString *)objFilePath;

/**
 get face transformed data

 @param index location of transform as follow
 #define LIPS_SMILE 0
 #define LIPS_UP 1
 #define LIPS_DOWN 2
 #define NOSE_BRIDGE 3
 #define NOSE_FAT 4
 #define VFACE 5
 #define FOREHEAD 6
 #define EXTERNAL_CANTHUS 7
 #define MEDIAL_CANTHUS 8
 #define APPLE_MUSCLE 9
 #define UP_CHIN 10
 #define DOWN_CHIN 11
 #define SMOOTH_POUCH 12
 #define PARALLEL_EYELID 13
 #define FAN_EYELID 14
 #define MOON_EYELID 15
 #define WESTERN_EYELID 16
 #define WHITENING 17
 #define SMOOTH_UV 18
 @param rate -10->10
 
 
 @return a transformed face data
 */
- (UnreFileData_out *)tranformFun:(int)index andValue:(float)rate;

/**
 get history transform rates

 @return history transform list
 */
- (float *) getCurrentDeformationScales;

/**
 get history user satisfied transform rates
 
 @return history transform list
 */
- (float *)getTemplateSatisfiedScales;

/**
 get unre fitted color point face data

 @return fitted color face data
 */
- (UnreFileData_out *) getUnreEncodingFaceData;

/**
 get user satisfied face data

 @return satisfied face data
 */
- (UnreFileData_out *)getTemplateSatisfiedData;

/**
 get original face data

 @return original face data UnreFileData_out address
 */
- (UnreFileData_out *)getOriginalObjData;

/**
 get current face landmarks
 @return current face landmarks UnreFaceLandMarks address
 */
- (UnreFaceLandMarks *)getCurrentFaceLandMarks;

/**
 get face landmarks
 @returnface landmarks UnreFaceLandMarks address
 */
- (UnreFaceLandMarks *)getFaceLandMarks;

/**
 set face landmarks
 @return bool
 */
-(BOOL)setFaceLandMarks:(UnreFaceLandMarks *)ldmk;

/**
 save user satisfied transform rate

 @param index face locations
 @param rate   transform rate -10->10
 @return saved or not
 */
- (BOOL)saveTemplateSatisfiedData:(int)index andRate:(float)rate;

/**
 get current transformed UnrefileData
 
 
 @return address of UnreFileData_out
 */

- (UnreFileData_out *)getCurrentUnreFileData;

-(BOOL)getFaceLoadStatus;

@end

NS_ASSUME_NONNULL_END
