//
//  manager2.h
//  nose_test_r
//
//  Created by 朱俊青 on 2018/10/30.
//  Copyright © 2018 朱俊青. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <SceneKit/SceneKit.h>
#include "UnreDataStructure.h"
NS_ASSUME_NONNULL_BEGIN

@protocol UnreFaceAnalysManagerDegelate <NSObject>
- (void) unreFaceAnalysManagerLoadFinish:(BOOL)result;
@end

@interface UnreFaceAnalysManager : NSObject
@property(nonatomic,weak)id<UnreFaceAnalysManagerDegelate> unreFaceAnalysManagerDelegate;
////////////////////

@property(nonatomic,strong) NSString * srcOBJFile;
@property(nonatomic,strong) NSString * srcMeshFile;
@property(nonatomic,strong) NSString * faceScaleData;

/**
 
 the constructor of UnreFaceAnalysMangager

 @return the object of UnreFaceAnalysMangager
 */
-(instancetype)initUnreFaceAnalysManager;

-(NSString *)getFaceScaleData;

/**
 get face analysis data from objFile and uvMap

 @param objPath the path of objFile
 @param uvMapPath the path of uvMap
 @return json string data
 */
-(NSString *)getUnreFaceAnalysDataFromFileWith:(NSString *)objPath andUV:(NSString *)uvMapPath;
/**
 get face analysis data from a face landmark

 @param landMark3D_ struct address of UnreFaceLandMarks
 @return json string data
 */
-(NSString *)getUnreFaceAnalyDataFromMemory:(UnreFaceLandMarks *)landMark3D_;
/**
 get different data from one face data after transform

 @param landmarkPoint3D struct address of UnreFaceLandMarks
 @param pc1 struct address of face data UnreFileData_out
 @param pc2 struct address of face data UnreFileData_out
 @return json string data
 */
-(NSString *)getUnreChangeDiffWith:(UnreFaceLandMarks *) landmarkPoint3D andPc1:(struct UnreFileData_out *)pc1 andPc2:(struct UnreFileData_out *)pc2;
/**
 get different data for two face data

 @param landmarkPoint3D2 struct address of UnreFaceLandMarks
 @param landmarkPoint3D1 struct address of UnreFaceLandMarks
 @param pc1 struct address of face data UnreFileData_out
 @param pc2 struct address of face data UnreFileData_out
 @return json string data
 */
-(NSString *)getUnreOverlyingDiffWith:(UnreFaceLandMarks *)landmarkPoint3D2 andLandMark:(UnreFaceLandMarks *)landmarkPoint3D1 andPc1:(struct UnreFileData_out *)pc1 andPc2:(struct UnreFileData_out *)pc2;


@end

NS_ASSUME_NONNULL_END
