//
//  GMNetworkMacros.h
//  Gengmei
//
//  Created by MoMo on 2019/8/15.
//  Copyright © 2019 更美互动信息科技有限公司. All rights reserved.
//

typedef void(^GMSuccessBlock)(id response);
typedef void(^GMFailureBlock)(NSInteger errorCode,NSString *message);
typedef void(^GMCompleteBlock)(BOOL isSuccess);

typedef NS_ENUM(NSInteger, GMCachePolicy) {
    GMCachePolicyNone = 0,// 无缓存
    GMCachePolicyIgnoryLocal = 0,// 忽略本地
    GMCachePolicyIgnoryNetWork = 0,// 忽略网络
};

typedef NS_ENUM(NSInteger, GMLoadingType) {
    GMLoadingTypeNone = 0,// 不展示
    GMLoadingTypeOne = 1,// 样式1
};

#define kInPageCount  10

#pragma mark - APP Global

#define API_APP_HONE_INDEX_POPUP                @"/api/app/home_index_popup"//首页弹窗
#define API_APP_CONFIG_V4                       @"/api/app/config_v4"// 获取首页展示时所需必要配置信息
#define API_INITIATE_LAUNCH                     @"/api/initiate/launch_data"// 获取初始化启动数据

#pragma mark - 社区
#define API_HOME_V8                             @"/api/index/v8"// 获取首页瀑布流数据
#define API_USER_OTHER_WATCH_LIST               @"/api/user/other_watch_list"// 大家都在看
#define API_SIGN_COMPLETE_TASK                  @"/api/user/sign_complete_task"// 签到任务完成接口
#define API_AI_WIKI_LIST                        @"/gm_ai/common/wiki_list"// 更美AI百科列表
#define API_DIARY_SERVICE                       @"/api/diary/service"// 获取日记关联美购
#define API_COMMON_REPLY                        @"/api/common/reply"// 一级评论
#define API_COMMON_SUB_REPLY                    @"/api/common/reply/sub_reply"// 二级评论
#define API_QUESTION_REPLY_ANSWER               @"/api/question/reply_answer"// 创建问答回复
#define API_ANSWER_COMMENT_VOTE                 @"/hybrid/answer/answer_reply_vote/_data"// 回答一级评论点赞
#define API_ANSWER_COMMENT_CANCEL_VOTE          @"/hybrid/answer/answer_reply_cancel_vote/_data"// 回答一级评论取消点赞
#define API_QUALITY_QUESTION_VOTE               @"/api/quality_question/vote"// 异形评论点赞
#define API_QUALITY_QUESTION_VOTE_CANCEL        @"/api/quality_question/vote_cancel"// 异形评论取消点赞
//日记评论回复点赞
#define API_TOPICREPLY_VOTE_DATA                @"/hybrid/api/topicreply/vote/_data"
//日记评论回复取消点赞
#define API_TOPICREPLY_CANCEL_VOTE_DATA         @"/hybrid/api/topicreply/cancel_vote/_data"
#define API_DAILY_CHECK_GET_EFFECTIVE_COUNT     @"/api/daily_check/get_effective_count"// 打卡获取 剩余有效打卡次数
#pragma mark - 用户
#define API_ACCOUNT_LOGIN_THIRD_PHONE_LOGIN     @"/api/account/login/third_phone_login"// 手机一键登录
/**@brief GET:获取手机验证码  POST:验证手机号 */
#define API_USER_PHONE                          @"/api/user/phone/"
/**@brief 获取国家区号 */
#define API_PHONE_AREA_CODE                     @"/api/phone_area_code"

#pragma mark - 交易
#define API_SETTLEMENT_PREVIEW_V1               @"/api/settlement/preview/v1"// 结算中心
#define API_SETTLEMENT_CREATE_V1                @"/api/settlement/create/v1"// 提交订单
#define API_SETTLEMENT_DETAIL                   @"/api/settlement/detail"// 获取订单详情
#define API_SETTLEMENT_CANCEL                   @"/api/settlement/delete"// 订单取消
#define API_VERTIFYFENXIANG_CODE                @"/api/fenxianggou/verify_code"// 验证分享购码
#define API_SETTLEMENT_PAYWAY                   @"/api/settlement/pay/v1"// 获取结算支付方式信息

