//
//  GMInterfaceNetwork.h
//  Gengmei
//
//  Created by MoMo on 2019/8/14.
//  Copyright © 2019 更美互动信息科技有限公司. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "GMALNetworkMacros.h"
#import "GMALBaseRequest.h"
#import "GMNetworking/GMNetworking-Swift.h"



@interface GMToFaceNetworking : NSObject

+ (instancetype)shareInstance;

#pragma mark - custum Requst

/**
 执行API请求

 @param uri URI
 @param method method
 @param params params
 @param successBlock successBlock
 @param failureBlock failureBlock
 @return dataTask
 */
- (NSURLSessionTask *)sendRequstWithApi:(NSString *)uri method:(GMHTTPMethod)method parameters:(NSDictionary *)params successBlock:(GMSuccessBlock)successBlock failureBlock:(GMFailureBlock)failureBlock;


/**
 执行API请求

 @param uri uri
 @param method method
 @param params params
 @param cachePolicy 缓存策略
 @param loadingType 加载动画类型
 @param successBlock successBlock
 @param failureBlock failureBlock
 @return dataTask
 */
- (NSURLSessionTask *)sendRequstWithApi:(NSString *)uri method:(GMHTTPMethod)method parameters:(NSDictionary *)params cachePolicy:(GMCachePolicy)cachePolicy loadingType:(GMLoadingType)loadingType successBlock:(GMSuccessBlock)successBlock failureBlock:(GMFailureBlock)failureBlock;




/**
 * 视频面诊 打星评价项获取
 * iagnosis_id   面诊 ID
 */
- (NSURLSessionTask *)excuteToFaceEvaluateItemDiagnosis_id:(NSString *)diagnosis_id
                                              SuccessBlock:(GMSuccessBlock)successBlock
                                              failureBlock:(GMFailureBlock)failureBlock;

/**
 * 视频面诊 获取投诉意见
 * diagnosis_id   面诊 ID
 */
- (NSURLSessionTask *)excuteToFaceComplaintGetDiagnosis_id:(NSString *)diagnosis_id
                                              SuccessBlock:(GMSuccessBlock)successBlock
                                              failureBlock:(GMFailureBlock)failureBlock;

/**
 * 视频面诊订单信息确认
 * order_no : 订单编号
 */
- (NSURLSessionTask *)excuteToFaceInfoSureOrder:(NSString *)order_no
                                   SuccessBlock:(GMSuccessBlock)successBlock
                                   failureBlock:(GMFailureBlock)failureBlock;

/**
 * 查看封禁信息
 */
- (NSURLSessionTask *)excuteToFaceBlockInfoSuccessBlock:(GMSuccessBlock)successBlock
                                           failureBlock:(GMFailureBlock)failureBlock;

/// 视频面诊频道推荐医生
- (NSURLSessionTask *)excuteToFaceRecommendDoctorsSuccessBlock:(GMSuccessBlock)successBlock
                                                  failureBlock:(GMFailureBlock)failureBlock;

/// 视频面诊频道tab 医生列表
- (NSURLSessionTask *)excuteToFaceTabsDoctorsTabsId:(NSInteger)tabsId
                                               page:(NSInteger)page
                                       SuccessBlock:(GMSuccessBlock)successBlock
                                       failureBlock:(GMFailureBlock)failureBlock;

/**
 * 视频面诊订单确认
 * order_no : 订单编号
 */
- (NSURLSessionTask *)excuteToFaceSureOrder:(NSString *)order_no
                               SuccessBlock:(GMSuccessBlock)successBlock
                               failureBlock:(GMFailureBlock)failureBlock;

/**
 * 视频面诊 打星评价
 * iagnosis_id   面诊 ID
 * star          星星数
 */
- (NSURLSessionTask *)excuteToFaceEvaluateDiagnosis_id:(NSString *)diagnosis_id
                                                  star:(NSInteger )star
                                          SuccessBlock:(GMSuccessBlock)successBlock
                                          failureBlock:(GMFailureBlock)failureBlock;
/**
 * 视频面诊 是否是医生本人
 * is_doctor      0不是医生本人 1 医生本人
 * diagnosis_id   面诊 ID
 */
- (NSURLSessionTask *)excuteToFaceIsSureDoctor:(NSInteger )is_doctor
                                  diagnosis_id:(NSString *)diagnosis_id
                                  SuccessBlock:(GMSuccessBlock)successBlock
                                  failureBlock:(GMFailureBlock)failureBlock;



@end


