//
//  GMFacePagingViewController.m
//  GMAILab
//
//  Created by 卢悦明 on 2020/5/12.
//

#import "GMFacePagingViewController.h"
#import <GMRefresh/GMRefreshHeader.h>
#import "WYSegmentView+Factory.h"

@implementation GMFacePagingViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    self.view.backgroundColor = [UIColor whiteColor];
    [self setupSubView];

    [_table removeFromSuperview];
    _table = nil;
    [self addNotification];
}

- (void)addNotification {
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(click_status:) name:@"appdelegate_touch_status" object:self.subViewVc];
}

#pragma mark - 点击状态栏
- (void)click_status:(NSNotification *)notification {
    UIViewController *vc = (UIViewController *)notification.object;
    if ([self.subViewVc isEqual:vc] && !self.pagerView.currentScrollingListView.decelerating) {
        [self.pagerView.currentScrollingListView setContentOffset:CGPointMake(0, 0)];
        [self.pagerView.mainTableView setContentOffset:CGPointZero animated:YES];
    }
}

- (void)removeNotification {
    [[NSNotificationCenter defaultCenter] removeObserver:self];
}

- (void)dealloc {
    [self removeNotification];
}

// 添加子控件
- (void)setupSubView {
    self.pagerView = [[JXPagerView alloc] initWithDelegate:self];
    CGFloat pagerViewH = MAINSCREEN_HEIGHT - OCNavigationBar.barHeight;
    self.pagerView.frame = CGRectMake(0, OCNavigationBar.barHeight, MAINSCREEN_WIDTH, pagerViewH);
    self.pagerView.pageCtrl = self;
    [self.view addSubview:self.pagerView];
    self.pagerView.clipsToBounds = false;
    self.pagerView.mainTableView.gestureDelegate = self;
    self.pagerView.listContainerView.collectionView.backgroundColor = UIColor.whiteColor;
    self.pagerView.mainTableView.backgroundColor = UIColor.background;
    self.pagerView.mainTableView.mj_header = [GMRefreshHeader headerWithRefreshingBlock:^{}];
    
    [self mainTableViewDidScroll:self.pagerView.mainTableView];
    
    [self.view addSubview:self.navigationBar];
    // 显示导航栏
//    [AppDelegate.tabBarController.tabBar showTabBar];
}

- (UIView *)headerView {
    if (!_headerView) {
        _headerView = [[GMView alloc] initWithFrame:CGRectMake(0, 0, MAINSCREEN_WIDTH, 0)];
        _headerView.backgroundColor = UIColor.whiteColor;
    }
    return _headerView;
}

- (WYSegmentView *)segmentView {
    if (!_segmentView) {
        _segmentView = self.segmentFullScreen ? [WYSegmentView fullWidthSegment] : [WYSegmentView dynamicSegment];
        _segmentView.frame = CGRectMake(0, self.headerView.height, MAINSCREEN_WIDTH, 40);
        _segmentView.titleTextAttributes = @{NSFontAttributeName:[UIFont gmFont:15],
                                             NSForegroundColorAttributeName:UIColor.auxiliaryTextDark};
        _segmentView.selectedTitleTextAttributes = @{NSFontAttributeName:[UIFont gmBoldFont:15],
                                                     NSForegroundColorAttributeName:UIColor.headlineText};
        _segmentView.itemHorizonalPadding = 14;
        _segmentView.bothEndPadding = 0;
        _segmentView.showIndicator = YES;
        _segmentView.clipsToBounds = NO;
        _segmentView.bottomLine.hidden = YES;
        [_segmentView addNavigationShadow];
        [_segmentView layoutSegments];
        __weak typeof(self) weakSelf = self;
        _segmentView.didSelectedBlock = ^(NSUInteger index) {
            weakSelf.index = index;
            [weakSelf.pagerView.listContainerView.collectionView scrollToItemAtIndexPath:[NSIndexPath indexPathForItem:index inSection:0] atScrollPosition:UICollectionViewScrollPositionCenteredHorizontally animated:NO];
        };
    }
    return _segmentView;
}

- (void)pagerView:(JXPagerView *)pagerView didScroll:(NSInteger)row {
    self.index = row;
    [self.segmentView setSelectedSegmentIndex:row animated:YES];
}

#pragma mark - JXPagerViewDelegate

- (UIView *)tableHeaderViewInPagerView:(JXPagerView *)pagerView {
    return self.headerView;
}

- (NSUInteger)tableHeaderViewHeightInPagerView:(JXPagerView *)pagerView {
    return ceil(self.headViewHeight);
}

- (NSUInteger)heightForPinSectionHeaderInPagerView:(JXPagerView *)pagerView {
    return self.segmentView.height;
}

- (UIView *)viewForPinSectionHeaderInPagerView:(JXPagerView *)pagerView {
    return self.segmentView;
}

- (NSInteger)numberOfListsInPagerView:(JXPagerView *)pagerView {
    return self.viewControllers.count;
}

#pragma mark - 需要子类重写
- (id<JXPagerViewListViewDelegate>)pagerView:(JXPagerView *)pagerView initListAtIndex:(NSInteger)index {
    return (id<JXPagerViewListViewDelegate>)[GMView new];
}

- (BOOL)mainTableViewGestureRecognizer:(UIGestureRecognizer *)gestureRecognizer shouldRecognizeSimultaneouslyWithGestureRecognizer:(UIGestureRecognizer *)otherGestureRecognizer {
    if (otherGestureRecognizer == self.segmentView.scrollView.panGestureRecognizer) {
        return NO;
    }
    return YES;
}

- (void)mainTableViewWillBeginDragging:(UIScrollView *)scrollView {
    
    UIScrollView *noCurrentScroView = self.pagerView.mainTableView;
    if (scrollView == self.pagerView.mainTableView) {
        [super scrollViewWillBeginDragging:scrollView];
        noCurrentScroView = self.pagerView.currentScrollingListView;
    }
    noCurrentScroView.pageCtrl.up_slide_times = scrollView.pageCtrl.up_slide_times;
    noCurrentScroView.pageCtrl.down_slide_times = scrollView.pageCtrl.down_slide_times;
}

- (void)mainTableViewDidEndDecelerating:(UIScrollView *)scrollView {
    
    UIScrollView *noCurrentScroView = self.pagerView.mainTableView;
    if (scrollView == self.pagerView.mainTableView) {
        [super scrollViewDidEndDecelerating:scrollView];
        noCurrentScroView = self.pagerView.currentScrollingListView;
    }
    [scrollView synchronizePageTimesToOther:noCurrentScroView];
}

- (void)mainTableViewDidEndDragging:(UIScrollView *)scrollView willDecelerate:(BOOL)decelerate {
    
    UIScrollView *noCurrentScroView = self.pagerView.mainTableView;
    if (scrollView == self.pagerView.mainTableView) {
        [super scrollViewDidEndDragging:scrollView willDecelerate:decelerate];
        noCurrentScroView = self.pagerView.currentScrollingListView;
    }
    [scrollView synchronizePageTimesToOther:noCurrentScroView];
}

#pragma mark - 需要子类重写
- (NSArray<UIViewController *> *)viewControllers {
    return _viewControllers;
}

- (void)mainTableViewDidScroll:(UIScrollView *)scrollView {
    
}

- (void)addKVO {
    [super addKVO];
}

- (void)removeKVO {
    [super removeKVO];
}

- (void)observeValueForKeyPath:(NSString *)keyPath ofObject:(id)object change:(NSDictionary *)change context:(void *)context {
    [super observeValueForKeyPath:keyPath ofObject:object change:change context:context];
}

@end
