//
//  GMFacePlayer.h
//  GMAILab
//
//  Created by 卢悦明 on 2020/5/13.
//

#import <PLPlayerKit/PLPlayerKit.h>



@protocol GMPlayerDelegate <NSObject>

/**
 手动拖拽只需要更新时间信息

 @param title 待展示的时间
 */
- (void)updateTimeTitle:(NSString *)title;

/**
 手动拖拽只需要更新时间信息

 @param title 待展示的时间
 */
- (void)updateBeginTimeTitle:(NSString *)title;

/**
 总时长

 @param title 待展示的时间
 */
- (void)updateTotalTimeTitle:(NSString *)title;

/**
 播放时，每0.5s秒调用一次该方法，返回直播进度。范围 0~1

 @param value 进度
 */
- (void)updateProgress:(CGFloat)value;
@end

@interface GMFacePlayer : PLPlayer

@property(nonatomic, assign) CGFloat current;
@property(nonatomic, weak) id<GMPlayerDelegate> progressDelegate;

/**
 播放前添加监听
 */
- (void)addProgressObserver;

// 使用该方法暂停播放器，而不是pause
- (void)pausePlayer;

// 下面两个方法只暂停timer，不暂停player
- (void)pauseTimer;
- (void)resumeTimer;

/**
 按照百分比进度快进、快退
 */
- (void)seekToProgress:(CGFloat)value;
-(NSString *)getMMSSFromSS:(float)totalTime;
@end

